/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;

public enum TraceDataFormatVersion {
    V1(0),
    V2(1);

    private static final String TRACE_VERSION_NAME = "profiler.trace.dataformat.version";
    private byte version;

    private TraceDataFormatVersion(byte version) {
        this.version = version;
    }

    public byte getVersion() {
        return this.version;
    }

    public static TraceDataFormatVersion getTraceDataFormatVersion(ProfilerConfig profilerConfig) {
        if (profilerConfig == null) {
            throw new NullPointerException("profilerConfig must not be null");
        }
        String lowerCaseVersion = profilerConfig.readString(TRACE_VERSION_NAME, "v1").toLowerCase();
        if ("v2".equals(lowerCaseVersion)) {
            return V2;
        }
        if ("v1".equals(lowerCaseVersion)) {
            return V1;
        }
        throw new UnsupportedOperationException("unknown profiler.trace.dataformat.version:" + lowerCaseVersion);
    }
}

