/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.httpclient3.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.httpclient3.HttpClient3Constants;

public class ExecuteInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor descriptor;

    public ExecuteInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        if (traceContext == null) {
            throw new NullPointerException("traceContext must not be null");
        }
        if (methodDescriptor == null) {
            throw new NullPointerException("methodDescriptor must not be null");
        }
        this.traceContext = traceContext;
        this.descriptor = methodDescriptor;
    }

    public void before(Object target, Object[] args) {
        Trace trace;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        trace.traceBlockBegin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordServiceType(HttpClient3Constants.HTTP_CLIENT_3_INTERNAL);
            recorder.recordApi(this.descriptor);
            recorder.recordException(throwable);
        }
        finally {
            trace.traceBlockEnd();
        }
    }
}

