/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.akka.http.interceptor;

import akka.http.javadsl.model.HttpResponse;
import akka.http.javadsl.model.StatusCode;
import akka.http.javadsl.server.Complete;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.plugin.akka.http.AkkaHttpConstants;
import com.navercorp.pinpoint.plugin.akka.http.interceptor.AsyncContextSpanEventEndPointInterceptor;
import scala.Option;
import scala.concurrent.Future;
import scala.util.Failure;
import scala.util.Success;

public class RequestContextImplCompleteInterceptor
extends AsyncContextSpanEventEndPointInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(RequestContextImplCompleteInterceptor.class);

    public RequestContextImplCompleteInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        super(traceContext, methodDescriptor);
    }

    @Override
    protected void doInBeforeTrace(SpanEventRecorder recorder, AsyncContext asyncContext, Object target, Object[] args) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        try {
            if (result instanceof Future && ((Future)result).isCompleted()) {
                Option value = ((Future)result).value();
                if (value == null) {
                    return;
                }
                Object routeResult = value.get();
                if (routeResult instanceof Success) {
                    Object success = ((Success)routeResult).get();
                    if (success instanceof Complete) {
                        HttpResponse response = ((Complete)success).getResponse();
                        if (response == null) {
                            return;
                        }
                        StatusCode status = response.status();
                        if (status == null) {
                            return;
                        }
                        recorder.recordAttribute(AnnotationKey.HTTP_STATUS_CODE, status.intValue());
                    }
                } else if (routeResult instanceof Failure) {
                    Throwable failure = ((Failure)routeResult).exception();
                    recorder.recordException(failure);
                }
            }
        }
        finally {
            recorder.recordApi(this.methodDescriptor);
            recorder.recordServiceType(AkkaHttpConstants.AKKA_HTTP_SERVER_INTERNAL);
            recorder.recordException(throwable);
        }
    }
}

