/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.spring.beans.interceptor;

import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.spring.beans.SpringBeansTargetScope;
import com.navercorp.pinpoint.plugin.spring.beans.interceptor.TargetBeanFilter;

public abstract class AbstractSpringBeanCreationInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final Instrumentor instrumentor;
    private final TransformCallback transformer;
    private final TargetBeanFilter filter;

    protected AbstractSpringBeanCreationInterceptor(Instrumentor instrumentor, TransformCallback transformer, TargetBeanFilter filter) {
        this.instrumentor = instrumentor;
        this.transformer = transformer;
        this.filter = filter;
    }

    protected final void processBean(String beanName, Object bean) {
        if (beanName == null || bean == null) {
            return;
        }
        Class<?> clazz = bean.getClass();
        if (clazz == null) {
            return;
        }
        if (!this.filter.isTarget(SpringBeansTargetScope.POST_PROCESSOR, beanName, clazz)) {
            return;
        }
        this.instrumentor.retransform(clazz, this.transformer);
        this.filter.addTransformed(clazz.getName());
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Retransform {}", (Object)clazz.getName());
        }
    }
}

