/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.agent.monitor;

import com.secnium.iast.agent.manager.EngineManager;
import com.secnium.iast.agent.monitor.IMonitor;

public class PerformanceMonitor
implements IMonitor {
    private final EngineManager engineManager;

    public PerformanceMonitor(EngineManager engineManager) {
        this.engineManager = engineManager;
    }

    public double memUsedRate() {
        double free = Runtime.getRuntime().freeMemory();
        double max = Runtime.getRuntime().maxMemory();
        return free / max;
    }

    public boolean isStop(double unUsedRate, int preStatus) {
        return unUsedRate < 0.2 && preStatus == 2;
    }

    public boolean isStart(double unUsedRate, int preStatus) {
        return unUsedRate > 0.2 && (preStatus == 1 || preStatus == 3);
    }

    public boolean isUninstall(double unUsedRate, int preStatus) {
        return unUsedRate < 0.1 && preStatus == 3;
    }

    public boolean isInstall(double unUsedRate, int preStatus) {
        return unUsedRate > 0.1 && preStatus == 4;
    }

    @Override
    public void check() {
        int preStatus;
        double unUsedRate = this.memUsedRate();
        if (this.isStart(unUsedRate, preStatus = this.engineManager.getRunningStatus())) {
            this.engineManager.start();
            this.engineManager.setRunningStatus(2);
        } else if (this.isStop(unUsedRate, preStatus)) {
            this.engineManager.stop();
            this.engineManager.setRunningStatus(3);
        } else if (this.isUninstall(unUsedRate, preStatus)) {
            this.engineManager.uninstall();
            this.engineManager.setRunningStatus(4);
        } else if (this.isInstall(unUsedRate, preStatus)) {
            this.engineManager.install();
            this.engineManager.setRunningStatus(1);
        }
    }
}

