/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.agent;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class IastProperties {
    private static IastProperties instance;
    public Properties cfg = new Properties();
    private String iastServerToken;
    private String serverUrl;
    private String proxyEnableStatus;
    private String proxyHost;
    private int proxyPort = -1;
    private int delayTime = -1;
    private String propertiesFilePath;

    private IastProperties(String path) {
        try {
            this.init(path);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static IastProperties getInstance() {
        if (null == instance) {
            instance = new IastProperties(null);
        }
        return instance;
    }

    public static IastProperties getInstance(String path) {
        if (null == instance) {
            instance = new IastProperties(path);
        }
        return instance;
    }

    public String getIastServerToken() {
        if (null == this.iastServerToken) {
            this.iastServerToken = null != this.cfg ? this.cfg.getProperty("iast.server.token", "88d2f0096662335d42580cbd03d8ddea745fdfab") : "88d2f0096662335d42580cbd03d8ddea745fdfab";
        }
        return this.iastServerToken;
    }

    public String getBaseUrl() {
        if (null == this.serverUrl) {
            this.serverUrl = System.getProperty("iast.server.url", this.cfg.getProperty("iast.server.url"));
        }
        return this.serverUrl;
    }

    public String getPropertiesFilePath() {
        return this.propertiesFilePath;
    }

    public String getEngineStatus() {
        return this.cfg.getProperty("engine.status");
    }

    public String getEngineName() {
        return this.cfg.getProperty("engine.name");
    }

    private String getProxyEnableStatus() {
        if (null == this.proxyEnableStatus) {
            this.proxyEnableStatus = System.getProperty("iast.proxy.enable", this.cfg.getProperty("iast.proxy.enable", "false"));
        }
        return this.proxyEnableStatus;
    }

    public boolean isProxyEnable() {
        return "true".equalsIgnoreCase(this.getProxyEnableStatus());
    }

    public String getProxyHost() {
        if (null == this.proxyHost) {
            this.proxyHost = System.getProperty("iast.proxy.host", this.cfg.getProperty("iast.proxy.host", "false"));
        }
        return this.proxyHost;
    }

    public int getProxyPort() {
        if (-1 == this.proxyPort) {
            this.proxyPort = Integer.parseInt(System.getProperty("iast.proxy.port", this.cfg.getProperty("iast.proxy.port", "80")));
        }
        return this.proxyPort;
    }

    public int getDelayTime() {
        if (-1 == this.delayTime) {
            this.delayTime = Integer.parseInt(System.getProperty("iast.engine.delay.time", "10"));
        }
        return this.delayTime;
    }

    public void init(String path) throws ClassNotFoundException {
        String basePath = null;
        try {
            int length;
            if (path != null) {
                this.propertiesFilePath = path;
            } else {
                File agentFile = new File(IastProperties.class.getProtectionDomain().getCodeSource().getLocation().getFile());
                basePath = agentFile.getParentFile().getPath();
                this.propertiesFilePath = basePath + File.separator + "config" + File.separator + "iast.properties";
            }
            File propertiesFile = new File(this.propertiesFilePath);
            if (!propertiesFile.exists()) {
                if (!propertiesFile.getParentFile().exists() && !propertiesFile.getParentFile().mkdirs()) {
                    throw new NullPointerException("\u914d\u7f6e\u6587\u4ef6\u521b\u5efa\u5931\u8d25");
                }
                propertiesFile.createNewFile();
            }
            InputStream is = IastProperties.class.getClassLoader().getResourceAsStream("iast.properties");
            FileOutputStream fos = new FileOutputStream(propertiesFile);
            byte[] data = new byte[1024];
            while (true) {
                assert (is != null);
                length = is.read(data);
                if (length < 1024) break;
                fos.write(data);
            }
            fos.write(data, 0, length);
            is.close();
            fos.close();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            this.cfg.load(inputStream);
            System.out.println("[cn.huoxian.dongtai.iast] The engine configuration file is initialized successfully. file is " + propertiesFile.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

