/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.activemq.client.interceptor;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.plugin.activemq.client.ActiveMQClientConstants;
import com.navercorp.pinpoint.plugin.activemq.client.ActiveMQClientHeader;
import com.navercorp.pinpoint.plugin.activemq.client.ActiveMQClientUtils;
import com.navercorp.pinpoint.plugin.activemq.client.descriptor.ActiveMQConsumerEntryMethodDescriptor;
import com.navercorp.pinpoint.plugin.activemq.client.field.getter.ActiveMQSessionGetter;
import com.navercorp.pinpoint.plugin.activemq.client.field.getter.SocketGetter;
import com.navercorp.pinpoint.plugin.activemq.client.field.getter.TransportGetter;
import com.navercorp.pinpoint.plugin.activemq.client.field.getter.URIGetter;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URI;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFilter;
import org.apache.activemq.transport.failover.FailoverTransport;

public class ActiveMQMessageConsumerDispatchInterceptor
implements AroundInterceptor {
    private static final ActiveMQConsumerEntryMethodDescriptor CONSUMER_ENTRY_METHOD_DESCRIPTOR = new ActiveMQConsumerEntryMethodDescriptor();
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor methodDescriptor;
    private final Filter<String> excludeDestinationFilter;

    public ActiveMQMessageConsumerDispatchInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor, Filter<String> excludeDestinationFilter) {
        this.traceContext = traceContext;
        this.methodDescriptor = methodDescriptor;
        this.excludeDestinationFilter = excludeDestinationFilter;
        traceContext.cacheApi((MethodDescriptor)CONSUMER_ENTRY_METHOD_DESCRIPTOR);
    }

    public void before(Object target, Object[] args) {
        block7: {
            if (!this.validate(target, args)) {
                return;
            }
            if (this.isDebug) {
                this.logger.beforeInterceptor(target, args);
            }
            try {
                Trace trace = this.createTrace(target, args);
                if (trace == null) {
                    return;
                }
                if (!trace.canSampled()) {
                    return;
                }
                SpanEventRecorder recorder = trace.traceBlockBegin();
                recorder.recordServiceType(ActiveMQClientConstants.ACTIVEMQ_CLIENT_INTERNAL);
                if (args[0] instanceof AsyncContextAccessor) {
                    AsyncContext asyncContext = recorder.recordNextAsyncContext();
                    ((AsyncContextAccessor)args[0])._$PINPOINT$_setAsyncContext(asyncContext);
                }
            }
            catch (Throwable th) {
                if (!this.logger.isWarnEnabled()) break block7;
                this.logger.warn("BEFORE. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (!this.validate(target, args)) {
            return;
        }
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((trace = this.traceContext.currentRawTraceObject()) == null) {
            return;
        }
        if (!trace.canSampled()) {
            this.traceContext.removeTraceObject();
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.methodDescriptor);
            if (throwable != null) {
                recorder.recordException(throwable);
            }
        }
        catch (Throwable th) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("after. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
        finally {
            this.traceContext.removeTraceObject();
            trace.traceBlockEnd();
            trace.close();
        }
    }

    private Trace createTrace(Object target, Object[] args) {
        Trace trace;
        if (!this.validate(target, args)) {
            return null;
        }
        MessageDispatch md = (MessageDispatch)args[0];
        ActiveMQMessage message = (ActiveMQMessage)md.getMessage();
        if (this.filterDestination(message.getDestination())) {
            return null;
        }
        if (!ActiveMQClientHeader.getSampled((javax.jms.Message)message, true).booleanValue()) {
            return this.traceContext.disableSampling();
        }
        TraceId traceId = this.populateTraceIdFromRequest(message);
        Trace trace2 = trace = traceId == null ? this.traceContext.newTraceObject() : this.traceContext.continueTraceObject(traceId);
        if (trace.canSampled()) {
            SpanRecorder recorder = trace.getSpanRecorder();
            this.recordRootSpan(recorder, target, args);
        }
        return trace;
    }

    private TraceId populateTraceIdFromRequest(ActiveMQMessage message) {
        String transactionId = ActiveMQClientHeader.getTraceId((javax.jms.Message)message, null);
        if (transactionId == null) {
            return null;
        }
        long parentSpanId = ActiveMQClientHeader.getParentSpanId((javax.jms.Message)message, -1L);
        long spanId = ActiveMQClientHeader.getSpanId((javax.jms.Message)message, -1L);
        short flags = ActiveMQClientHeader.getFlags((javax.jms.Message)message, (short)0);
        return this.traceContext.createTraceId(transactionId, parentSpanId, spanId, flags);
    }

    private boolean filterDestination(ActiveMQDestination destination) {
        String destinationName = destination.getPhysicalName();
        return this.excludeDestinationFilter.filter((Object)destinationName);
    }

    private void recordRootSpan(SpanRecorder recorder, Object target, Object[] args) {
        recorder.recordServiceType(ActiveMQClientConstants.ACTIVEMQ_CLIENT);
        recorder.recordApi((MethodDescriptor)CONSUMER_ENTRY_METHOD_DESCRIPTOR);
        ActiveMQSession session = ((ActiveMQSessionGetter)target)._$PINPOINT$_getActiveMQSession();
        ActiveMQConnection connection = session.getConnection();
        Transport transport = this.getRootTransport(((TransportGetter)connection)._$PINPOINT$_getTransport());
        String endPoint = this.getEndPoint(transport);
        recorder.recordEndPoint(endPoint);
        String remoteAddress = transport.getRemoteAddress();
        recorder.recordRemoteAddress(remoteAddress);
        MessageDispatch md = (MessageDispatch)args[0];
        ActiveMQMessage message = (ActiveMQMessage)md.getMessage();
        ActiveMQDestination destination = message.getDestination();
        recorder.recordRpcName(destination.getQualifiedName());
        recorder.recordAcceptorHost(destination.getPhysicalName());
        String parentApplicationName = ActiveMQClientHeader.getParentApplicationName((javax.jms.Message)message, null);
        if (!recorder.isRoot() && parentApplicationName != null) {
            short parentApplicationType = ActiveMQClientHeader.getParentApplicationType((javax.jms.Message)message, ServiceType.UNDEFINED.getCode());
            recorder.recordParentApplication(parentApplicationName, parentApplicationType);
        }
    }

    private String getEndPoint(Transport transport) {
        if (transport instanceof SocketGetter) {
            Socket socket = ((SocketGetter)transport)._$PINPOINT$_getSocket();
            SocketAddress localSocketAddress = socket.getLocalSocketAddress();
            return ActiveMQClientUtils.getEndPoint(localSocketAddress);
        }
        if (transport instanceof URIGetter) {
            URI uri = ((URIGetter)transport)._$PINPOINT$_getUri();
            return HostAndPort.toHostAndPortString((String)uri.getHost(), (int)uri.getPort());
        }
        return null;
    }

    private boolean validate(Object target, Object[] args) {
        if (!(target instanceof ActiveMQMessageConsumer)) {
            return false;
        }
        if (!(target instanceof ActiveMQSessionGetter)) {
            if (this.isDebug) {
                this.logger.debug("Invalid target object. Need field accessor({}).", (Object)ActiveMQSessionGetter.class.getName());
            }
            return false;
        }
        if (!this.validateTransport(((ActiveMQSessionGetter)target)._$PINPOINT$_getActiveMQSession())) {
            return false;
        }
        if (args == null || args.length < 1) {
            return false;
        }
        if (!(args[0] instanceof MessageDispatch)) {
            return false;
        }
        MessageDispatch md = (MessageDispatch)args[0];
        Message message = md.getMessage();
        return message instanceof ActiveMQMessage;
    }

    private boolean validateTransport(ActiveMQSession session) {
        if (session == null) {
            return false;
        }
        ActiveMQConnection connection = session.getConnection();
        if (!(connection instanceof TransportGetter)) {
            if (this.isDebug) {
                this.logger.debug("Invalid connection object. Need field accessor({}).", (Object)TransportGetter.class.getName());
            }
            return false;
        }
        Transport transport = this.getRootTransport(((TransportGetter)connection)._$PINPOINT$_getTransport());
        if (!(transport instanceof SocketGetter)) {
            if (this.isDebug) {
                this.logger.debug("Transport not traceable({}).", (Object)transport.getClass().getName());
            }
            return false;
        }
        return true;
    }

    private Transport getRootTransport(Transport transport) {
        Transport possiblyWrappedTransport = transport;
        while (possiblyWrappedTransport instanceof TransportFilter) {
            if (!((possiblyWrappedTransport = ((TransportFilter)possiblyWrappedTransport).getNext()) instanceof FailoverTransport)) continue;
            possiblyWrappedTransport = ((FailoverTransport)possiblyWrappedTransport).getConnectedTransport();
        }
        return possiblyWrappedTransport;
    }
}

