/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.cxf;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.util.Arrays;
import java.util.List;

public class CxfPluginConfig {
    private final boolean serviceProfile;
    private final boolean loggingProfile;
    @Deprecated
    private final boolean clientProfile;
    @Deprecated
    private final String[] clientHiddenParams;

    public CxfPluginConfig(ProfilerConfig src) {
        this.serviceProfile = src.readBoolean("profiler.cxf.service.enable", false);
        this.loggingProfile = src.readBoolean("profiler.cxf.logging.enable", false);
        this.clientProfile = src.readBoolean("profiler.cxf.client", false);
        this.clientHiddenParams = this.getStringArray(src.readString("profiler.cxf.client.hiddenParams", ""));
    }

    public boolean isServiceProfile() {
        return this.serviceProfile;
    }

    public boolean isLoggingProfile() {
        return this.loggingProfile;
    }

    @Deprecated
    public boolean isClientProfile() {
        return this.clientProfile;
    }

    @Deprecated
    public String[] getClientHiddenParams() {
        return this.clientHiddenParams;
    }

    @Deprecated
    private String[] getStringArray(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        List tokenList = StringUtils.tokenizeToStringList((String)value, (String)",");
        return this.toStringArray(tokenList);
    }

    @Deprecated
    private String[] toStringArray(List<String> list) {
        if (list == null) {
            return null;
        }
        return list.toArray(new String[0]);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CxfPluginConfig [serviceProfile=");
        builder.append(this.serviceProfile);
        builder.append(", loggingProfile=");
        builder.append(this.loggingProfile);
        builder.append(", clientProfile(Deprecated)=");
        builder.append(this.clientProfile);
        builder.append(", clientHiddenParams(Deprecated)=");
        builder.append(Arrays.toString(this.clientHiddenParams));
        builder.append("]");
        return builder.toString();
    }
}

