/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.java9.module;

import com.navercorp.pinpoint.bootstrap.java9.module.JarPackageAnalyzer;
import com.navercorp.pinpoint.bootstrap.java9.module.ModuleException;
import com.navercorp.pinpoint.bootstrap.java9.module.ModuleLogger;
import java.io.Closeable;
import java.io.IOException;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import jdk.internal.loader.BootLoader;
import jdk.internal.module.Modules;

class ModuleBuilder {
    private final ModuleLogger logger = ModuleLogger.getLogger(this.getClass().getName());

    ModuleBuilder() {
    }

    Module defineModule(String moduleName, ClassLoader classLoader, URL[] urls) {
        if (moduleName == null) {
            throw new NullPointerException("moduleName must not be null");
        }
        if (urls == null) {
            throw new NullPointerException("urls must not be null");
        }
        if (urls.length == 0) {
            throw new IllegalArgumentException("urls.length is 0");
        }
        this.logger.info("bootstrap unnamedModule:" + BootLoader.getUnnamedModule());
        this.logger.info("platform unnamedModule:" + ClassLoader.getPlatformClassLoader().getUnnamedModule());
        this.logger.info("system unnamedModule:" + ClassLoader.getSystemClassLoader().getUnnamedModule());
        Module unnamedModule = classLoader.getUnnamedModule();
        this.logger.info("defineModule classLoader: " + classLoader);
        this.logger.info("defineModule classLoader-unnamedModule: " + unnamedModule);
        Set<String> packages = this.getPackages(urls);
        this.logger.info("packages:" + packages);
        ModuleDescriptor.Builder builder = ModuleDescriptor.newModule(moduleName);
        builder.packages(packages);
        ModuleDescriptor moduleDescriptor = builder.build();
        URI url = this.getInformationURI(urls);
        Module module = Modules.defineModule(classLoader, moduleDescriptor, url);
        this.logger.info("defineModule module:" + module);
        return module;
    }

    private JarFile newJarFile(URL jarFile) {
        try {
            if (!jarFile.getProtocol().equals("file")) {
                throw new IllegalStateException("invalid file " + jarFile);
            }
            return new JarFile(jarFile.getFile());
        }
        catch (IOException e) {
            throw new ModuleException(jarFile.getFile() + " create fail " + e.getMessage(), e);
        }
    }

    private URI getInformationURI(URL[] urls) {
        if (this.isEmpty(urls)) {
            return null;
        }
        URL url = urls[0];
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean isEmpty(URL[] urls) {
        return urls == null || urls.length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getPackages(URL[] urls) {
        HashSet<String> sum = new HashSet<String>();
        for (URL url : urls) {
            if (!this.isJar(url)) continue;
            JarFile jarFile = null;
            try {
                jarFile = this.newJarFile(url);
                JarPackageAnalyzer packageAnalyzer = new JarPackageAnalyzer(jarFile);
                Set<String> newPackage = packageAnalyzer.getPackage();
                sum.addAll(newPackage);
            }
            finally {
                this.close(jarFile);
            }
        }
        return sum;
    }

    private boolean isJar(URL url) {
        return url.getPath().endsWith(".jar");
    }

    private void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

