/*
 * Decompiled with CFR 0.152.
 */
package com.tapm.starter.logger;

import com.tapm.starter.Constants;
import com.tapm.starter.logger.ILogger;
import com.tapm.starter.logger.MessageFormatter;
import com.tapm.starter.logger.appender.Appender;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SimpleFormatLogger
implements ILogger {
    private String name;
    private final String formater = "%s [%s] [%s] %s - %s";

    public SimpleFormatLogger(String name) {
        this.name = name;
    }

    private void writeLog(String level, String message, Object ... arguments) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formated = null;
        if (arguments != null && arguments.length > 0) {
            formated = MessageFormatter.arrayFormat(message, arguments).getMessage();
            formated = String.format("%s [%s] [%s] %s - %s", dateFormat.format(new Date()), Thread.currentThread().getName(), this.name, level, formated);
        } else {
            formated = String.format("%s [%s] [%s] %s - %s", dateFormat.format(new Date()), Thread.currentThread().getName(), this.name, level, message);
        }
        Appender.getAppender().append(formated);
    }

    private void writeLog(String level, String message, Throwable thr) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        thr.printStackTrace(writer);
        String throwMessage = out.toString();
        String formated = String.format("%s [%s] [%s] %s - %s", dateFormat.format(new Date()), Thread.currentThread().getName(), this.name, level, message);
        Appender.getAppender().append(formated);
        Appender.getAppender().append(throwMessage);
    }

    @Override
    public boolean isDebugEnabled() {
        return Constants.DEBUG_ENABLED;
    }

    @Override
    public void debug(String msg) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.writeLog("DEBUG", msg, new Object[0]);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.writeLog("DEBUG", format, arguments);
    }

    @Override
    public void info(String msg) {
        this.writeLog("INFO", msg, new Object[0]);
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.writeLog("INFO", format, arguments);
    }

    @Override
    public void error(String msg) {
        this.writeLog("ERROR", msg, new Object[0]);
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.writeLog("ERROR", format, arguments);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.writeLog("ERROR", msg, t);
    }

    @Override
    public void warn(String message) {
        this.writeLog("WARN", message, new Object[0]);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.writeLog("WARN", msg, t);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.writeLog("WARN", format, arguments);
    }
}

