/*
 * Decompiled with CFR 0.152.
 */
package com.tapm.starter.flow.processors;

import com.tapm.starter.AgentClassLoader;
import com.tapm.starter.AgentStarter;
import com.tapm.starter.flow.IProcessor;
import com.tapm.starter.flow.ProcessContext;
import com.tapm.starter.flow.exception.ProcessException;
import com.tapm.starter.logger.ILogger;
import com.tapm.starter.logger.LoggerFactory;
import java.lang.reflect.Method;
import java.net.URL;

public class InstallAgentProcessor
implements IProcessor {
    private ILogger logger = LoggerFactory.getLogger("InstallAgentProcessor");
    private volatile ClassLoader tapmClassLoader;

    @Override
    public String process(ProcessContext context) throws ProcessException {
        String[] args = (String[])context.get("agent_main_args");
        try {
            Class<?> agentClass = this.getBootstrapAgentClass();
            Method premain = agentClass.getDeclaredMethod("install", String[].class);
            premain.invoke(null, new Object[]{args});
        }
        catch (Throwable e) {
            this.logger.error("Error start up Tapm agent", e);
        }
        return "finished";
    }

    private Class<?> getBootstrapAgentClass() throws Throwable {
        ClassLoader agentLoader = this.loadOrDifineClassLoader();
        return agentLoader.loadClass("com.tapm.bootstrap.BootstrapAgentByStarter");
    }

    private ClassLoader loadOrDifineClassLoader() throws Throwable {
        if (null != this.tapmClassLoader) {
            return this.tapmClassLoader;
        }
        URL agent_path_url = AgentStarter.class.getProtectionDomain().getCodeSource().getLocation();
        URL url = new URL(agent_path_url, "tapm-agent-core.jar");
        this.tapmClassLoader = new AgentClassLoader(url);
        return this.tapmClassLoader;
    }
}

