/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jetty;

import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.AsyncListenerInterceptorHelper;
import java.io.IOException;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JettyAsyncListener
implements AsyncListener {
    private PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private boolean isDebug = this.logger.isDebugEnabled();
    private final boolean isInfo = this.logger.isInfoEnabled();
    private final AsyncListenerInterceptorHelper asyncListenerInterceptorHelper;

    public JettyAsyncListener(TraceContext traceContext, AsyncContext asyncContext) {
        this.asyncListenerInterceptorHelper = new AsyncListenerInterceptorHelper(traceContext, asyncContext);
    }

    public void onComplete(AsyncEvent asyncEvent) throws IOException {
        block5: {
            if (this.isDebug) {
                this.logger.debug("Complete asynchronous operation. event={}", (Object)asyncEvent);
            }
            if (asyncEvent == null) {
                if (this.isInfo) {
                    this.logger.info("Invalid event. event is null");
                }
                return;
            }
            try {
                int statusCode = this.getStatusCode(asyncEvent);
                Throwable throwable = this.getThrowable(asyncEvent);
                this.asyncListenerInterceptorHelper.complete(throwable, statusCode);
            }
            catch (Throwable t) {
                if (!this.isInfo) break block5;
                this.logger.info("Failed to async event handle. asyncEvent={}", (Object)asyncEvent, (Object)t);
            }
        }
    }

    public void onTimeout(AsyncEvent asyncEvent) throws IOException {
        if (this.isDebug) {
            this.logger.debug("Timeout asynchronous operation. event={}", (Object)asyncEvent);
        }
        if (asyncEvent == null) {
            if (this.isDebug) {
                this.logger.debug("Invalid event. event is null");
            }
            return;
        }
        try {
            this.asyncListenerInterceptorHelper.timeout(asyncEvent.getThrowable());
        }
        catch (Throwable t) {
            this.logger.info("Failed to async event handle. event={}", (Object)asyncEvent, (Object)t);
        }
    }

    public void onError(AsyncEvent asyncEvent) throws IOException {
        block5: {
            if (this.isDebug) {
                this.logger.debug("Error asynchronous operation. event={}", (Object)asyncEvent);
            }
            if (asyncEvent == null) {
                if (this.isInfo) {
                    this.logger.info("Invalid event. event is null");
                }
                return;
            }
            try {
                Throwable throwable = this.getThrowable(asyncEvent);
                this.asyncListenerInterceptorHelper.error(throwable);
            }
            catch (Throwable t) {
                if (!this.isInfo) break block5;
                this.logger.info("Failed to async event handle. asyncEvent={}", (Object)asyncEvent, (Object)t);
            }
        }
    }

    public void onStartAsync(AsyncEvent asyncEvent) throws IOException {
    }

    private int getStatusCode(AsyncEvent asyncEvent) {
        try {
            if (asyncEvent.getSuppliedResponse() instanceof HttpServletResponse) {
                return ((HttpServletResponse)asyncEvent.getSuppliedResponse()).getStatus();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private Throwable getThrowable(AsyncEvent asyncEvent) {
        try {
            Object errorException;
            if (asyncEvent.getThrowable() != null) {
                return asyncEvent.getThrowable();
            }
            ServletRequest request = asyncEvent.getSuppliedRequest();
            if (request != null && (errorException = request.getAttribute("javax.servlet.error.exception")) instanceof Throwable) {
                return (Throwable)errorException;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

