/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jdbc.oracle;

import com.navercorp.pinpoint.bootstrap.context.DatabaseInfo;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.DefaultDatabaseInfo;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.JdbcUrlParserV2;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.StringMaker;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.UnKnownDatabaseInfo;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.plugin.jdbc.oracle.OracleConstants;
import com.navercorp.pinpoint.plugin.jdbc.oracle.parser.Description;
import com.navercorp.pinpoint.plugin.jdbc.oracle.parser.KeyValue;
import com.navercorp.pinpoint.plugin.jdbc.oracle.parser.OracleNetConnectionDescriptorParser;
import java.util.ArrayList;
import java.util.List;

public class OracleJdbcUrlParser
implements JdbcUrlParserV2 {
    private static final String URL_PREFIX = "jdbc:oracle:";
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());

    public DatabaseInfo parse(String jdbcUrl) {
        if (jdbcUrl == null) {
            this.logger.info("jdbcUrl must not be null");
            return UnKnownDatabaseInfo.INSTANCE;
        }
        if (!jdbcUrl.startsWith(URL_PREFIX)) {
            this.logger.info("jdbcUrl has invalid prefix.(url:{}, prefix:{})", (Object)jdbcUrl, (Object)URL_PREFIX);
            return UnKnownDatabaseInfo.INSTANCE;
        }
        DatabaseInfo result = null;
        try {
            result = this.parse0(jdbcUrl);
        }
        catch (Exception e) {
            this.logger.info("OracleJdbcUrl parse error. url: {}, Caused: {}", new Object[]{jdbcUrl, e.getMessage(), e});
            result = UnKnownDatabaseInfo.createUnknownDataBase((ServiceType)OracleConstants.ORACLE, (ServiceType)OracleConstants.ORACLE_EXECUTE_QUERY, (String)jdbcUrl);
        }
        return result;
    }

    private DatabaseInfo parse0(String jdbcUrl) {
        StringMaker maker = new StringMaker(jdbcUrl);
        maker.after(URL_PREFIX).after(":");
        String description = maker.after('@').value().trim();
        if (description.startsWith("(")) {
            return this.parseNetConnectionUrl(jdbcUrl);
        }
        return this.parseSimpleUrl(jdbcUrl, maker);
    }

    private DatabaseInfo parseNetConnectionUrl(String url) {
        OracleNetConnectionDescriptorParser parser = new OracleNetConnectionDescriptorParser(url);
        KeyValue keyValue = parser.parse();
        return this.createOracleDatabaseInfo(keyValue, url);
    }

    private DefaultDatabaseInfo parseSimpleUrl(String url, StringMaker maker) {
        String host = maker.before(':').value();
        String port = maker.next().after(':').before(':', '/').value();
        String databaseId = maker.next().afterLast(':', '/').value();
        ArrayList<String> hostList = new ArrayList<String>(1);
        hostList.add(host + ":" + port);
        return new DefaultDatabaseInfo(OracleConstants.ORACLE, OracleConstants.ORACLE_EXECUTE_QUERY, url, url, hostList, databaseId);
    }

    private DatabaseInfo createOracleDatabaseInfo(KeyValue keyValue, String url) {
        Description description = new Description(keyValue);
        List<String> jdbcHost = description.getJdbcHost();
        return new DefaultDatabaseInfo(OracleConstants.ORACLE, OracleConstants.ORACLE_EXECUTE_QUERY, url, url, jdbcHost, description.getDatabaseId());
    }

    public ServiceType getServiceType() {
        return OracleConstants.ORACLE;
    }
}

