/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.agentdir;

import com.navercorp.pinpoint.bootstrap.agentdir.AgentDirBaseClassPathResolver;
import com.navercorp.pinpoint.common.annotations.VisibleForTesting;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaAgentPathResolver {
    static final String JAVA_AGENT_OPTION = "-javaagent:";
    private final Pattern DEFAULT_AGENT_PATTERN = AgentDirBaseClassPathResolver.DEFAULT_AGENT_BOOTSTRAP_PATTERN;
    private final ResolvingType resolvingType;

    JavaAgentPathResolver(ResolvingType resolvingType) {
        if (resolvingType == null) {
            throw new NullPointerException("type must not be null");
        }
        this.resolvingType = resolvingType;
    }

    public static JavaAgentPathResolver newJavaAgentPathResolver() {
        ResolvingType resolvingType = JavaAgentPathResolver.getResolvingType();
        return new JavaAgentPathResolver(resolvingType);
    }

    private static ResolvingType getResolvingType() {
        String type = System.getProperty("pinpoint.javaagent.resolving", "");
        if (type.equalsIgnoreCase("system")) {
            return ResolvingType.SYSTEM_PROPERTY;
        }
        return ResolvingType.INPUT_ARGUMENT;
    }

    public String resolveJavaAgentPath() {
        if (this.resolvingType == ResolvingType.SYSTEM_PROPERTY) {
            return this.getClassPathFromSystemProperty();
        }
        RuntimeMXBean runtimeMXBean = this.getRuntimeMXBean();
        List<String> inputArguments = runtimeMXBean.getInputArguments();
        for (String inputArgument : inputArguments) {
            if (!this.isPinpointAgent(inputArgument, this.DEFAULT_AGENT_PATTERN)) continue;
            return this.removeJavaAgentPrefix(inputArgument);
        }
        throw new IllegalArgumentException("-javaagent: not found");
    }

    @VisibleForTesting
    RuntimeMXBean getRuntimeMXBean() {
        return ManagementFactory.getRuntimeMXBean();
    }

    private String removeJavaAgentPrefix(String inputArgument) {
        return inputArgument.substring(JAVA_AGENT_OPTION.length(), inputArgument.length());
    }

    private boolean isPinpointAgent(String inputArgument, Pattern javaPattern) {
        if (!inputArgument.startsWith(JAVA_AGENT_OPTION)) {
            return false;
        }
        Matcher matcher = javaPattern.matcher(inputArgument);
        return matcher.find();
    }

    String getClassPathFromSystemProperty() {
        return System.getProperty("java.class.path");
    }

    static enum ResolvingType {
        INPUT_ARGUMENT,
        SYSTEM_PROPERTY;

    }
}

