/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.agentdir;

import com.navercorp.pinpoint.bootstrap.agentdir.BootDir;
import java.io.File;
import java.net.URL;
import java.util.List;

public class AgentDirectory {
    private final String agentJarName;
    private final String agentJarFullPath;
    private final String agentDirPath;
    private final BootDir bootDir;
    private final List<String> plugins;
    private final List<URL> libs;

    public AgentDirectory(String agentJarName, String agentJarFullPath, String agentDirPath, BootDir bootDir, List<URL> libs, List<String> plugins) {
        if (bootDir == null) {
            throw new NullPointerException("bootDir must not be null");
        }
        this.agentJarName = agentJarName;
        this.agentJarFullPath = agentJarFullPath;
        this.agentDirPath = agentDirPath;
        this.bootDir = bootDir;
        this.libs = libs;
        this.plugins = plugins;
    }

    public BootDir getBootDir() {
        return this.bootDir;
    }

    public List<URL> getLibs() {
        return this.libs;
    }

    public List<String> getPlugins() {
        return this.plugins;
    }

    public String getAgentJarName() {
        return this.agentJarName;
    }

    public String getAgentJarFullPath() {
        return this.agentJarFullPath;
    }

    public String getAgentDirPath() {
        return this.agentDirPath;
    }

    public String getAgentLibPath() {
        return this.agentDirPath + File.separator + "lib";
    }

    public String getAgentLogFilePath() {
        return this.agentDirPath + File.separator + "log";
    }

    public String getAgentPluginPath() {
        return this.agentDirPath + File.separator + "plugin";
    }

    public String getAgentConfigPath() {
        return this.agentDirPath + File.separator + "pinpoint.config";
    }
}

