/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.netty.interceptor.http;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessorUtils;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.context.scope.TraceScope;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientHeaderAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestWrapper;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestWrapperAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.DefaultRequestTraceWriter;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestTraceWriter;
import com.navercorp.pinpoint.plugin.netty.NettyClientRequestWrapper;
import com.navercorp.pinpoint.plugin.netty.NettyConfig;
import com.navercorp.pinpoint.plugin.netty.NettyConstants;
import com.navercorp.pinpoint.plugin.netty.NettyUtils;
import com.navercorp.pinpoint.plugin.netty.field.accessor.AsyncStartFlagFieldAccessor;
import com.navercorp.pinpoint.plugin.netty.interceptor.http.HttpMessageClientHeaderAdaptor;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpMessage;

public class HttpEncoderInterceptor
implements AroundInterceptor {
    protected final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    protected final boolean isDebug = this.logger.isDebugEnabled();
    protected static final String ASYNC_TRACE_SCOPE = "##ASYNC_TRACE_SCOPE";
    private final TraceContext traceContext;
    protected final MethodDescriptor methodDescriptor;
    private final ClientRequestRecorder<ClientRequestWrapper> clientRequestRecorder;
    private final RequestTraceWriter<HttpMessage> requestTraceWriter;

    public HttpEncoderInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        if (traceContext == null) {
            throw new NullPointerException("traceContext must not be null");
        }
        if (methodDescriptor == null) {
            throw new NullPointerException("methodDescriptor must not be null");
        }
        this.traceContext = traceContext;
        this.methodDescriptor = methodDescriptor;
        NettyConfig config = new NettyConfig(traceContext.getProfilerConfig());
        ClientRequestAdaptor clientRequestAdaptor = ClientRequestWrapperAdaptor.INSTANCE;
        this.clientRequestRecorder = new ClientRequestRecorder(config.isParam(), clientRequestAdaptor);
        HttpMessageClientHeaderAdaptor clientHeaderAdaptor = new HttpMessageClientHeaderAdaptor();
        this.requestTraceWriter = new DefaultRequestTraceWriter((ClientHeaderAdaptor)clientHeaderAdaptor, traceContext);
    }

    public void before(Object target, Object[] args) {
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if (!this.validate(args)) {
            return;
        }
        Trace trace = this.traceContext.currentRawTraceObject();
        if (trace == null) {
            this.beforeAsync(target, args);
        } else {
            this.before0(trace, target, args);
        }
    }

    private void before0(Trace trace, Object target, Object[] args) {
        if (!trace.canSampled()) {
            HttpMessage httpMessage = (HttpMessage)args[1];
            this.requestTraceWriter.write((Object)httpMessage);
            return;
        }
        SpanEventRecorder recorder = trace.traceBlockBegin();
        this.doInBeforeTrace(recorder, trace, target, args);
    }

    private void beforeAsync(Object target, Object[] args) {
        block4: {
            ((AsyncStartFlagFieldAccessor)args[1])._$PINPOINT$_setAsyncStartFlag(true);
            AsyncContext asyncContext = this.getAsyncContext(args[1]);
            if (asyncContext == null) {
                this.logger.debug("AsyncContext not found");
                return;
            }
            Trace trace = this.getAsyncTrace(asyncContext);
            if (trace == null) {
                return;
            }
            this.entryAsyncTraceScope(trace);
            try {
                SpanEventRecorder recorder = trace.traceBlockBegin();
                this.doInBeforeTrace(recorder, trace, target, args);
            }
            catch (Throwable th) {
                if (!this.logger.isWarnEnabled()) break block4;
                this.logger.warn("BEFORE. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
    }

    protected void doInBeforeTrace(SpanEventRecorder recorder, Trace trace, Object target, Object[] args) {
        TraceId nextId = trace.getTraceId().getNextTraceId();
        recorder.recordNextSpanId(nextId.getSpanId());
        recorder.recordServiceType(NettyConstants.SERVICE_TYPE_CODEC_HTTP);
        ChannelHandlerContext channelHandlerContext = (ChannelHandlerContext)args[0];
        HttpMessage httpMessage = (HttpMessage)args[1];
        String host = this.getHost(channelHandlerContext);
        this.requestTraceWriter.write((Object)httpMessage, nextId, host);
    }

    private String getHost(ChannelHandlerContext channelHandlerContext) {
        Channel channel;
        if (channelHandlerContext != null && (channel = channelHandlerContext.channel()) != null) {
            return NettyUtils.getEndPoint(channel.remoteAddress());
        }
        return null;
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if (!this.validate(args)) {
            return;
        }
        boolean async = ((AsyncStartFlagFieldAccessor)args[1])._$PINPOINT$_getAsyncStartFlag();
        if (async) {
            this.afterAsync(target, args, result, throwable);
        } else {
            this.after0(target, args, result, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void after0(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace = this.traceContext.currentRawTraceObject();
        if (trace == null) {
            return;
        }
        if (!trace.canSampled()) {
            return;
        }
        SpanEventRecorder recorder = trace.currentSpanEventRecorder();
        try {
            this.doInAfterTrace(recorder, target, args, result, throwable);
        }
        finally {
            trace.traceBlockEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterAsync(Object target, Object[] args, Object result, Throwable throwable) {
        AsyncContext asyncContext = this.getAsyncContext(args[1]);
        if (asyncContext == null) {
            this.logger.debug("AsyncContext not found");
            return;
        }
        Trace trace = asyncContext.currentAsyncTraceObject();
        if (trace == null) {
            return;
        }
        if (!this.leaveAsyncTraceScope(trace)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Failed to leave scope of async trace {}.", (Object)trace);
            }
            this.deleteAsyncContext(trace, asyncContext);
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            this.doInAfterTrace(recorder, target, args, result, throwable);
        }
        catch (Throwable th) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("AFTER error. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
        finally {
            trace.traceBlockEnd();
            if (this.isAsyncTraceDestination(trace)) {
                this.deleteAsyncContext(trace, asyncContext);
            }
        }
    }

    protected void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        recorder.recordApi(this.methodDescriptor);
        recorder.recordException(throwable);
        ChannelHandlerContext channelHandlerContext = (ChannelHandlerContext)args[0];
        HttpMessage httpMessage = (HttpMessage)args[1];
        this.clientRequestRecorder.record(recorder, (Object)new NettyClientRequestWrapper(httpMessage, channelHandlerContext), throwable);
    }

    protected AsyncContext getAsyncContext(Object target) {
        return AsyncContextAccessorUtils.getAsyncContext((Object)target);
    }

    private Trace getAsyncTrace(AsyncContext asyncContext) {
        Trace trace = asyncContext.continueAsyncTraceObject();
        if (trace == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Failed to continue async trace. 'result is null'");
            }
            return null;
        }
        if (this.isDebug) {
            this.logger.debug("getAsyncTrace() trace {}, asyncContext={}", (Object)trace, (Object)asyncContext);
        }
        return trace;
    }

    private void deleteAsyncContext(Trace trace, AsyncContext asyncContext) {
        if (this.isDebug) {
            this.logger.debug("Delete async trace {}.", (Object)trace);
        }
        trace.close();
        asyncContext.close();
    }

    private void entryAsyncTraceScope(Trace trace) {
        TraceScope scope = trace.getScope(ASYNC_TRACE_SCOPE);
        if (scope != null) {
            scope.tryEnter();
        }
    }

    private boolean leaveAsyncTraceScope(Trace trace) {
        TraceScope scope = trace.getScope(ASYNC_TRACE_SCOPE);
        if (scope != null) {
            if (scope.canLeave()) {
                scope.leave();
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean isAsyncTraceDestination(Trace trace) {
        if (!trace.isAsync()) {
            return false;
        }
        TraceScope scope = trace.getScope(ASYNC_TRACE_SCOPE);
        return scope != null && !scope.isActive();
    }

    private boolean validate(Object[] args) {
        if (args.length != 3) {
            return false;
        }
        if (!(args[0] instanceof ChannelHandlerContext)) {
            return false;
        }
        ChannelHandlerContext channelHandlerContext = (ChannelHandlerContext)args[0];
        Channel channel = channelHandlerContext.channel();
        if (channel == null) {
            return false;
        }
        if (!(args[1] instanceof HttpMessage)) {
            return false;
        }
        HttpMessage httpMessage = (HttpMessage)args[1];
        if (httpMessage.headers() == null) {
            return false;
        }
        if (!(args[1] instanceof AsyncContextAccessor)) {
            return false;
        }
        return args[1] instanceof AsyncStartFlagFieldAccessor;
    }
}

