/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.gson.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor2;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.gson.GsonConstants;

public class FromJsonInterceptor
implements AroundInterceptor2 {
    private final TraceContext traceContext;
    private final MethodDescriptor descriptor;
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());

    public FromJsonInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        this.traceContext = traceContext;
        this.descriptor = descriptor;
    }

    public void before(Object target, Object arg0, Object arg1) {
        Trace trace;
        if (this.logger.isDebugEnabled()) {
            this.logger.beforeInterceptor(target, new Object[]{arg0, arg1});
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        trace.traceBlockBegin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object arg0, Object arg1, Object result, Throwable throwable) {
        Trace trace;
        if (this.logger.isDebugEnabled()) {
            this.logger.afterInterceptor(target, new Object[]{arg0, arg1}, result, throwable);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordServiceType(GsonConstants.GSON_SERVICE_TYPE);
            recorder.recordApi(this.descriptor);
            recorder.recordException(throwable);
            if (arg0 != null && arg0 instanceof String) {
                recorder.recordAttribute(GsonConstants.GSON_ANNOTATION_KEY_JSON_LENGTH, ((String)arg0).length());
            }
        }
        finally {
            trace.traceBlockEnd();
        }
    }
}

