/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.service;

import com.navercorp.pinpoint.common.service.ServiceTypeRegistryService;
import com.navercorp.pinpoint.common.service.TraceMetadataLoaderService;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.trace.ServiceTypeInfo;
import com.navercorp.pinpoint.common.trace.ServiceTypeRegistry;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.StaticFieldLookUp;
import com.navercorp.pinpoint.common.util.logger.CommonLogger;
import com.navercorp.pinpoint.common.util.logger.CommonLoggerFactory;
import java.util.List;

public class DefaultServiceTypeRegistryService
implements ServiceTypeRegistryService {
    private final CommonLogger logger;
    private final TraceMetadataLoaderService typeLoaderService;
    private final ServiceTypeRegistry registry;

    public DefaultServiceTypeRegistryService(TraceMetadataLoaderService typeLoaderService, CommonLoggerFactory commonLoggerFactory) {
        Assert.requireNonNull(commonLoggerFactory, "commonLoggerFactory must not be null");
        this.logger = commonLoggerFactory.getLogger(DefaultServiceTypeRegistryService.class.getName());
        this.typeLoaderService = Assert.requireNonNull(typeLoaderService, "typeLoaderService must not be null");
        this.registry = this.buildServiceTypeRegistry();
    }

    private ServiceTypeRegistry buildServiceTypeRegistry() {
        ServiceTypeRegistry.Builder builder = new ServiceTypeRegistry.Builder();
        StaticFieldLookUp<ServiceType> staticFieldLookUp = new StaticFieldLookUp<ServiceType>(ServiceType.class, ServiceType.class);
        List<ServiceType> lookup = staticFieldLookUp.lookup();
        for (ServiceType serviceType : lookup) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("add Default ServiceType:" + serviceType);
            }
            builder.addServiceType(serviceType);
        }
        List<ServiceTypeInfo> types = this.loadType();
        for (ServiceTypeInfo type : types) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("add Plugin ServiceType:" + type.getServiceType());
            }
            builder.addServiceType(type.getServiceType());
        }
        return builder.build();
    }

    private List<ServiceTypeInfo> loadType() {
        return this.typeLoaderService.getServiceTypeInfos();
    }

    @Override
    public ServiceType findServiceType(short serviceType) {
        return this.registry.findServiceType(serviceType);
    }

    @Override
    public ServiceType findServiceTypeByName(String typeName) {
        return this.registry.findServiceTypeByName(typeName);
    }

    @Override
    public List<ServiceType> findDesc(String desc) {
        return this.registry.findDesc(desc);
    }
}

