/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.okhttp.v2;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.BasicMethodInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.okhttp.OkHttpConstants;
import com.navercorp.pinpoint.plugin.okhttp.OkHttpPluginConfig;
import java.security.ProtectionDomain;

public class OkHttpPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        OkHttpPluginConfig config = new OkHttpPluginConfig(context.getConfig());
        if (!config.isEnable()) {
            this.logger.info("Disable OkHttpPlugin 2.x");
            return;
        }
        this.logger.info("Setup OkHttpPlugin 2.x");
        this.addCall();
        this.addDispatcher();
        if (config.isAsync()) {
            this.addAsyncCall();
        }
        this.addHttpEngine(config);
        this.addRequestBuilder();
    }

    private void addCall() {
        this.transformTemplate.transform("com.squareup.okhttp.Call", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"execute", "enqueue", "cancel"}))) {
                    method.addScopedInterceptor(BasicMethodInterceptor.class.getName(), VarArgs.va((Object[])new Object[]{OkHttpConstants.OK_HTTP_CLIENT_INTERNAL}), "CallScope");
                }
                return target.toBytecode();
            }
        });
    }

    private void addDispatcher() {
        this.transformTemplate.transform("com.squareup.okhttp.Dispatcher", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"execute", "cancel"}))) {
                    method.addInterceptor(BasicMethodInterceptor.class.getName(), VarArgs.va((Object[])new Object[]{OkHttpConstants.OK_HTTP_CLIENT_INTERNAL}));
                }
                InstrumentMethod enqueueMethod = target.getDeclaredMethod("enqueue", new String[]{"com.squareup.okhttp.Call$AsyncCall"});
                if (enqueueMethod != null) {
                    enqueueMethod.addInterceptor("com.navercorp.pinpoint.plugin.okhttp.interceptor.DispatcherEnqueueMethodInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addAsyncCall() {
        this.transformTemplate.transform("com.squareup.okhttp.Call$AsyncCall", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod executeMethod = target.getDeclaredMethod("execute", new String[0]);
                if (executeMethod != null) {
                    target.addField(AsyncContextAccessor.class.getName());
                    executeMethod.addInterceptor("com.navercorp.pinpoint.plugin.okhttp.interceptor.AsyncCallExecuteMethodInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addHttpEngine(final OkHttpPluginConfig config) {
        this.transformTemplate.transform("com.squareup.okhttp.internal.http.HttpEngine", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentMethod connectMethod;
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addGetter("com.navercorp.pinpoint.plugin.okhttp.v2.UserRequestGetter", "userRequest");
                target.addGetter("com.navercorp.pinpoint.plugin.okhttp.v2.UserResponseGetter", "userResponse");
                InstrumentMethod sendRequestMethod = target.getDeclaredMethod("sendRequest", new String[0]);
                if (sendRequestMethod != null) {
                    sendRequestMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.okhttp.v2.interceptor.HttpEngineSendRequestMethodInterceptor", "SendRequestScope");
                }
                if (target.hasField("connection", "com.squareup.okhttp.Connection")) {
                    InstrumentMethod connectMethodWithParam;
                    target.addGetter("com.navercorp.pinpoint.plugin.okhttp.v2.ConnectionGetter", "connection");
                    connectMethod = target.getDeclaredMethod("connect", new String[0]);
                    if (connectMethod != null) {
                        connectMethod.addInterceptor("com.navercorp.pinpoint.plugin.okhttp.v2.interceptor.HttpEngineConnectMethodInterceptor");
                    }
                    if ((connectMethodWithParam = target.getDeclaredMethod("connect", new String[]{"com.squareup.okhttp.Request"})) != null) {
                        connectMethodWithParam.addInterceptor("com.navercorp.pinpoint.plugin.okhttp.v2.interceptor.HttpEngineConnectMethodInterceptor");
                    }
                } else {
                    connectMethod = target.getDeclaredMethod("connect", new String[0]);
                    if (connectMethod != null) {
                        connectMethod.addInterceptor("com.navercorp.pinpoint.plugin.okhttp.v2.interceptor.HttpEngineConnectMethodFromUserRequestInterceptor");
                    }
                }
                InstrumentMethod readResponseMethod = target.getDeclaredMethod("readResponse", new String[0]);
                if (readResponseMethod != null) {
                    readResponseMethod.addInterceptor("com.navercorp.pinpoint.plugin.okhttp.v2.interceptor.HttpEngineReadResponseMethodInterceptor", VarArgs.va((Object[])new Object[]{config.isStatusCode()}));
                }
                return target.toBytecode();
            }
        });
    }

    private void addRequestBuilder() {
        this.transformTemplate.transform("com.squareup.okhttp.Request$Builder", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod buildMethod = target.getDeclaredMethod("build", new String[0]);
                if (buildMethod != null) {
                    if (instrumentor.exist(loader, "com.squareup.okhttp.HttpUrl", protectionDomain)) {
                        target.addGetter("com.navercorp.pinpoint.plugin.okhttp.v2.HttpUrlGetter", "url");
                        buildMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.okhttp.v2.interceptor.RequestBuilderBuildMethodInterceptor", "SendRequestScope", ExecutionPolicy.INTERNAL);
                    } else {
                        target.addGetter("com.navercorp.pinpoint.plugin.okhttp.v2.UrlGetter", "url");
                        buildMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.okhttp.v2.interceptor.RequestBuilderBuildMethodBackwardCompatibilityInterceptor", "SendRequestScope", ExecutionPolicy.INTERNAL);
                    }
                }
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

