/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.mongo;

public final class Base64 {
    private static final int BYTES_PER_UNENCODED_BLOCK = 3;
    private static final int BYTES_PER_ENCODED_BLOCK = 4;
    private static final int SIX_BIT_MASK = 63;
    private static final byte PAD = 61;
    private static final byte[] ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};

    public static String encode(byte[] in) {
        return Base64.encode(in, 0, in.length);
    }

    public static String encode(byte[] in, int offset, int length) {
        int modulus = 0;
        int bitWorkArea = 0;
        int numEncodedBytes = length / 3 * 4 + (length % 3 == 0 ? 0 : 4);
        byte[] buffer = new byte[numEncodedBytes];
        int pos = 0;
        for (int i = offset; i < length; ++i) {
            byte b = in[i];
            modulus = (modulus + 1) % 3;
            if (b < 0) {
                b = (byte)(b + 256);
            }
            bitWorkArea = (bitWorkArea << 8) + b;
            if (0 != modulus) continue;
            buffer[pos++] = ENCODE_TABLE[bitWorkArea >> 18 & 0x3F];
            buffer[pos++] = ENCODE_TABLE[bitWorkArea >> 12 & 0x3F];
            buffer[pos++] = ENCODE_TABLE[bitWorkArea >> 6 & 0x3F];
            buffer[pos++] = ENCODE_TABLE[bitWorkArea & 0x3F];
        }
        switch (modulus) {
            case 1: {
                buffer[pos++] = ENCODE_TABLE[bitWorkArea >> 2 & 0x3F];
                buffer[pos++] = ENCODE_TABLE[bitWorkArea << 4 & 0x3F];
                buffer[pos++] = 61;
                buffer[pos] = 61;
                break;
            }
            case 2: {
                buffer[pos++] = ENCODE_TABLE[bitWorkArea >> 10 & 0x3F];
                buffer[pos++] = ENCODE_TABLE[bitWorkArea >> 4 & 0x3F];
                buffer[pos++] = ENCODE_TABLE[bitWorkArea << 2 & 0x3F];
                buffer[pos] = 61;
                break;
            }
        }
        return Base64.byteArrayToString(buffer);
    }

    private static String byteArrayToString(byte[] buffer) {
        return new String(buffer, 0, 0, buffer.length);
    }

    private Base64() {
    }
}

