/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.trace;

import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.trace.AnnotationKeyMatcher;
import com.navercorp.pinpoint.common.trace.DefaultServiceTypeInfo;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.trace.ServiceTypeInfo;
import com.navercorp.pinpoint.common.trace.TraceMetadataProvider;
import com.navercorp.pinpoint.common.trace.TraceMetadataSetupContext;
import com.navercorp.pinpoint.common.util.logger.CommonLogger;
import com.navercorp.pinpoint.common.util.logger.CommonLoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TraceMetadataLoader {
    private final CommonLogger logger;
    private final List<ServiceTypeInfo> serviceTypeInfos = new ArrayList<ServiceTypeInfo>();
    private final ServiceTypeChecker serviceTypeChecker = new ServiceTypeChecker();
    private final List<AnnotationKey> annotationKeys = new ArrayList<AnnotationKey>();
    private final AnnotationKeyChecker annotationKeyChecker = new AnnotationKeyChecker();

    public TraceMetadataLoader(CommonLoggerFactory loggerFactory) {
        if (loggerFactory == null) {
            throw new NullPointerException("loggerFactory must not be null");
        }
        this.logger = loggerFactory.getLogger(TraceMetadataLoader.class.getName());
    }

    public void load(List<TraceMetadataProvider> providers) {
        if (providers == null) {
            throw new NullPointerException("providers must not be null");
        }
        this.logger.info("Loading TraceMetadataProviders");
        for (TraceMetadataProvider provider : providers) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Loading TraceMetadataProvider: " + provider.getClass().getName() + " name:" + provider.toString());
            }
            TraceMetadataSetupContextImpl context = new TraceMetadataSetupContextImpl(provider.getClass());
            provider.setup(context);
        }
        this.serviceTypeChecker.logResult();
        this.annotationKeyChecker.logResult();
    }

    public List<ServiceTypeInfo> getServiceTypeInfos() {
        return this.serviceTypeInfos;
    }

    public List<AnnotationKey> getAnnotationKeys() {
        return this.annotationKeys;
    }

    private static String serviceTypePairToString(Pair<ServiceType> pair) {
        return ((ServiceType)((Pair)pair).value).getName() + "(" + ((ServiceType)((Pair)pair).value).getCode() + ") from " + ((Pair)pair).provider.getName();
    }

    private static String annotationKeyPairToString(Pair<AnnotationKey> pair) {
        return ((AnnotationKey)((Pair)pair).value).getName() + "(" + ((AnnotationKey)((Pair)pair).value).getCode() + ") from " + ((Pair)pair).provider.getName();
    }

    private class AnnotationKeyChecker {
        private final Map<Integer, Pair<AnnotationKey>> annotationKeyCodeMap = new HashMap<Integer, Pair<AnnotationKey>>();

        private AnnotationKeyChecker() {
        }

        private void check(AnnotationKey key, Class<?> providerClass) {
            Pair<AnnotationKey> pair = new Pair<AnnotationKey>(key, providerClass);
            Pair<AnnotationKey> prev = this.annotationKeyCodeMap.put(key.getCode(), pair);
            if (prev != null) {
                throw new RuntimeException("AnnotationKey code of " + TraceMetadataLoader.annotationKeyPairToString(pair) + " is duplicated with " + TraceMetadataLoader.annotationKeyPairToString(prev));
            }
        }

        private void logResult() {
            TraceMetadataLoader.this.logger.info("Finished loading AnnotationKeys:");
            ArrayList<Pair<AnnotationKey>> annotationKeys = new ArrayList<Pair<AnnotationKey>>(this.annotationKeyCodeMap.values());
            Collections.sort(annotationKeys, new Comparator<Pair<AnnotationKey>>(){

                @Override
                public int compare(Pair<AnnotationKey> o1, Pair<AnnotationKey> o2) {
                    int code2;
                    int code1 = ((AnnotationKey)((Pair)o1).value).getCode();
                    return code1 > (code2 = ((AnnotationKey)((Pair)o2).value).getCode()) ? 1 : (code1 < code2 ? -1 : 0);
                }
            });
            for (Pair pair : annotationKeys) {
                TraceMetadataLoader.this.logger.info(TraceMetadataLoader.annotationKeyPairToString(pair));
            }
        }
    }

    private class ServiceTypeChecker {
        private final Map<String, Pair<ServiceType>> serviceTypeNameMap = new HashMap<String, Pair<ServiceType>>();
        private final Map<Short, Pair<ServiceType>> serviceTypeCodeMap = new HashMap<Short, Pair<ServiceType>>();

        private ServiceTypeChecker() {
        }

        private void check(ServiceType type, Class<?> providerClass) {
            Pair<ServiceType> pair = new Pair<ServiceType>(type, providerClass);
            Pair<ServiceType> prev = this.serviceTypeNameMap.put(type.getName(), pair);
            if (prev != null) {
                throw new RuntimeException("ServiceType name of " + TraceMetadataLoader.serviceTypePairToString(pair) + " is duplicated with " + TraceMetadataLoader.serviceTypePairToString(prev));
            }
            prev = this.serviceTypeCodeMap.put(type.getCode(), pair);
            if (prev != null) {
                throw new RuntimeException("ServiceType code of " + TraceMetadataLoader.serviceTypePairToString(pair) + " is duplicated with " + TraceMetadataLoader.serviceTypePairToString(prev));
            }
        }

        private void logResult() {
            TraceMetadataLoader.this.logger.info("Finished loading ServiceType:");
            ArrayList<Pair<ServiceType>> serviceTypes = new ArrayList<Pair<ServiceType>>(this.serviceTypeCodeMap.values());
            Collections.sort(serviceTypes, new Comparator<Pair<ServiceType>>(){

                @Override
                public int compare(Pair<ServiceType> o1, Pair<ServiceType> o2) {
                    short code2;
                    short code1 = ((ServiceType)((Pair)o1).value).getCode();
                    return code1 > (code2 = ((ServiceType)((Pair)o2).value).getCode()) ? 1 : (code1 < code2 ? -1 : 0);
                }
            });
            for (Pair pair : serviceTypes) {
                TraceMetadataLoader.this.logger.info(TraceMetadataLoader.serviceTypePairToString(pair));
            }
        }
    }

    private static class Pair<T> {
        private final T value;
        private final Class<?> provider;

        public Pair(T value, Class<?> provider) {
            this.value = value;
            this.provider = provider;
        }
    }

    private class TraceMetadataSetupContextImpl
    implements TraceMetadataSetupContext {
        private final Class<?> provider;

        public TraceMetadataSetupContextImpl(Class<?> provider) {
            this.provider = provider;
        }

        @Override
        public void addServiceType(ServiceType serviceType) {
            if (serviceType == null) {
                throw new NullPointerException("serviceType must not be null");
            }
            DefaultServiceTypeInfo type = new DefaultServiceTypeInfo(serviceType);
            this.addType0(type);
        }

        @Override
        public void addServiceType(ServiceType serviceType, AnnotationKeyMatcher annotationKeyMatcher) {
            if (serviceType == null) {
                throw new NullPointerException("serviceType must not be null");
            }
            if (annotationKeyMatcher == null) {
                throw new NullPointerException("annotationKeyMatcher must not be null");
            }
            DefaultServiceTypeInfo type = new DefaultServiceTypeInfo(serviceType, annotationKeyMatcher);
            this.addType0(type);
        }

        private void addType0(ServiceTypeInfo type) {
            if (type == null) {
                throw new NullPointerException("type must not be null");
            }
            TraceMetadataLoader.this.serviceTypeChecker.check(type.getServiceType(), this.provider);
            TraceMetadataLoader.this.serviceTypeInfos.add(type);
        }

        @Override
        public void addAnnotationKey(AnnotationKey annotationKey) {
            if (annotationKey == null) {
                throw new NullPointerException("annotationKey must not be null");
            }
            TraceMetadataLoader.this.annotationKeyChecker.check(annotationKey, this.provider);
            TraceMetadataLoader.this.annotationKeys.add(annotationKey);
        }
    }
}

