/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.buffer;

import com.navercorp.pinpoint.common.buffer.Buffer;
import com.navercorp.pinpoint.common.util.BytesUtils;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class FixedBuffer
implements Buffer {
    protected static final int NULL = -1;
    protected byte[] buffer;
    protected int offset;

    public FixedBuffer() {
        this(32);
    }

    public FixedBuffer(int bufferSize) {
        if (bufferSize < 0) {
            throw new IndexOutOfBoundsException("negative bufferSize:" + bufferSize);
        }
        this.buffer = new byte[bufferSize];
        this.offset = 0;
    }

    public FixedBuffer(byte[] buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer must not be null");
        }
        this.buffer = buffer;
        this.offset = 0;
    }

    @Override
    public void putPadBytes(byte[] bytes, int totalLength) {
        if (bytes == null) {
            bytes = EMPTY;
        }
        if (bytes.length > totalLength) {
            throw new IndexOutOfBoundsException("bytes too big:" + bytes.length + " totalLength:" + totalLength);
        }
        this.putBytes(bytes);
        int padSize = totalLength - bytes.length;
        if (padSize > 0) {
            this.putPad(padSize);
        }
    }

    private void putPad(int padSize) {
        for (int i = 0; i < padSize; ++i) {
            this.putByte((byte)0);
        }
    }

    @Override
    public void putPrefixedBytes(byte[] bytes) {
        if (bytes == null) {
            this.putSVInt(-1);
        } else {
            this.putSVInt(bytes.length);
            this.putBytes(bytes);
        }
    }

    @Override
    public void put2PrefixedBytes(byte[] bytes) {
        if (bytes == null) {
            this.putShort((short)-1);
        } else {
            if (bytes.length > Short.MAX_VALUE) {
                throw new IndexOutOfBoundsException("too large bytes length:" + bytes.length);
            }
            this.putShort((short)bytes.length);
            this.putBytes(bytes);
        }
    }

    @Override
    public void put4PrefixedBytes(byte[] bytes) {
        if (bytes == null) {
            this.putInt(-1);
        } else {
            this.putInt(bytes.length);
            this.putBytes(bytes);
        }
    }

    @Override
    public void putPadString(String string, int totalLength) {
        byte[] bytes = BytesUtils.toBytes(string);
        this.putPadBytes(bytes, totalLength);
    }

    @Override
    public void putPrefixedString(String string) {
        byte[] bytes = BytesUtils.toBytes(string);
        this.putPrefixedBytes(bytes);
    }

    @Override
    public void put2PrefixedString(String string) {
        byte[] bytes = BytesUtils.toBytes(string);
        if (bytes == null) {
            this.putShort((short)-1);
            return;
        }
        if (bytes.length > Short.MAX_VALUE) {
            throw new IndexOutOfBoundsException("too large String size:" + bytes.length);
        }
        this.put2PrefixedBytes(bytes);
    }

    @Override
    public void put4PrefixedString(String string) {
        byte[] bytes = BytesUtils.toBytes(string);
        if (bytes == null) {
            this.putInt(-1);
            return;
        }
        this.put4PrefixedBytes(bytes);
    }

    @Override
    public void putByte(byte v) {
        this.buffer[this.offset++] = v;
    }

    @Override
    public void putBoolean(boolean v) {
        this.buffer[this.offset++] = v ? (byte)1 : 0;
    }

    @Override
    public void putInt(int v) {
        this.offset = BytesUtils.writeInt(v, this.buffer, this.offset);
    }

    @Override
    public void putVInt(int v) {
        if (v >= 0) {
            this.putVar32(v);
        } else {
            this.putVar64(v);
        }
    }

    @Override
    public void putSVInt(int v) {
        this.offset = BytesUtils.writeSVar32(v, this.buffer, this.offset);
    }

    private void putVar32(int v) {
        this.offset = BytesUtils.writeVar32(v, this.buffer, this.offset);
    }

    @Override
    public void putShort(short v) {
        this.offset = BytesUtils.writeShort(v, this.buffer, this.offset);
    }

    @Override
    public void putLong(long v) {
        this.offset = BytesUtils.writeLong(v, this.buffer, this.offset);
    }

    @Override
    public void putVLong(long v) {
        this.putVar64(v);
    }

    @Override
    public void putSVLong(long v) {
        this.putVar64(BytesUtils.longToZigZag(v));
    }

    private void putVar64(long v) {
        this.offset = BytesUtils.writeVar64(v, this.buffer, this.offset);
    }

    @Override
    public void putDouble(double v) {
        this.putLong(Double.doubleToRawLongBits(v));
    }

    @Override
    public void putVDouble(double v) {
        this.putVLong(Double.doubleToRawLongBits(v));
    }

    @Override
    public void putSVDouble(double v) {
        this.putSVLong(Double.doubleToRawLongBits(v));
    }

    @Override
    public void putBytes(byte[] v) {
        if (v == null) {
            throw new NullPointerException("v must not be null");
        }
        System.arraycopy(v, 0, this.buffer, this.offset, v.length);
        this.offset += v.length;
    }

    @Override
    public byte getByte(int index) {
        return this.buffer[this.offset];
    }

    @Override
    public byte readByte() {
        return this.buffer[this.offset++];
    }

    @Override
    public int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    @Override
    public boolean readBoolean() {
        byte b = this.readByte();
        return b == 1;
    }

    @Override
    public int readInt() {
        int i = BytesUtils.bytesToInt(this.buffer, this.offset);
        this.offset += 4;
        return i;
    }

    @Override
    public int readVInt() {
        block4: {
            int x;
            int pos;
            block6: {
                byte[] buffer;
                block8: {
                    block7: {
                        block5: {
                            int bufferSize = this.buffer.length;
                            pos = this.offset;
                            if (bufferSize == pos) break block4;
                            buffer = this.buffer;
                            if ((x = buffer[pos++]) >= 0) {
                                this.offset = pos;
                                return x;
                            }
                            if (bufferSize - pos < 9) break block4;
                            if ((x ^= buffer[pos++] << 7) >= 0) break block5;
                            x ^= 0xFFFFFF80;
                            break block6;
                        }
                        if ((x ^= buffer[pos++] << 14) < 0) break block7;
                        x ^= 0x3F80;
                        break block6;
                    }
                    if ((x ^= buffer[pos++] << 21) >= 0) break block8;
                    x ^= 0xFFE03F80;
                    break block6;
                }
                byte y = buffer[pos++];
                x ^= y << 28;
                x ^= 0xFE03F80;
                if (y < 0 && buffer[pos++] < 0 && buffer[pos++] < 0 && buffer[pos++] < 0 && buffer[pos++] < 0 && buffer[pos++] < 0) break block4;
            }
            this.offset = pos;
            return x;
        }
        return (int)this.readVar64SlowPath();
    }

    long readVar64SlowPath() {
        int copyOffset = this.offset;
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.buffer[copyOffset++];
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            this.offset = copyOffset;
            return result;
        }
        throw new IllegalArgumentException("invalid varLong. start offset:" + this.offset + " readOffset:" + this.offset);
    }

    @Override
    public int readSVInt() {
        return BytesUtils.zigzagToInt(this.readVInt());
    }

    @Deprecated
    public int readSVarInt() {
        return this.readSVInt();
    }

    @Override
    public short readShort() {
        short i = BytesUtils.bytesToShort(this.buffer, this.offset);
        this.offset += 2;
        return i;
    }

    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public long readLong() {
        long l = BytesUtils.bytesToLong(this.buffer, this.offset);
        this.offset += 8;
        return l;
    }

    @Override
    public long readVLong() {
        block4: {
            long x;
            int pos;
            block6: {
                byte[] buffer;
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block7: {
                                        block5: {
                                            byte y;
                                            int bufferSize = this.buffer.length;
                                            pos = this.offset;
                                            if (bufferSize == pos) break block4;
                                            buffer = this.buffer;
                                            if ((y = buffer[pos++]) >= 0) {
                                                this.offset = pos;
                                                return y;
                                            }
                                            if (bufferSize - pos < 9) break block4;
                                            if ((x = (long)(y ^ buffer[pos++] << 7)) >= 0L) break block5;
                                            x ^= 0xFFFFFFFFFFFFFF80L;
                                            break block6;
                                        }
                                        if ((x ^= (long)(buffer[pos++] << 14)) < 0L) break block7;
                                        x ^= 0x3F80L;
                                        break block6;
                                    }
                                    if ((x ^= (long)(buffer[pos++] << 21)) >= 0L) break block8;
                                    x ^= 0xFFFFFFFFFFE03F80L;
                                    break block6;
                                }
                                if ((x ^= (long)buffer[pos++] << 28) < 0L) break block9;
                                x ^= 0xFE03F80L;
                                break block6;
                            }
                            if ((x ^= (long)buffer[pos++] << 35) >= 0L) break block10;
                            x ^= 0xFFFFFFF80FE03F80L;
                            break block6;
                        }
                        if ((x ^= (long)buffer[pos++] << 42) < 0L) break block11;
                        x ^= 0x3F80FE03F80L;
                        break block6;
                    }
                    if ((x ^= (long)buffer[pos++] << 49) >= 0L) break block12;
                    x ^= 0xFFFE03F80FE03F80L;
                    break block6;
                }
                x ^= (long)buffer[pos++] << 56;
                if ((x ^= 0xFE03F80FE03F80L) < 0L && (long)buffer[pos++] < 0L) break block4;
            }
            this.offset = pos;
            return x;
        }
        return this.readVar64SlowPath();
    }

    @Override
    public long readSVLong() {
        return BytesUtils.zigzagToLong(this.readVLong());
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public double readVDouble() {
        return Double.longBitsToDouble(this.readVLong());
    }

    @Override
    public double readSVDouble() {
        return Double.longBitsToDouble(this.readSVLong());
    }

    @Override
    public byte[] readPadBytes(int totalLength) {
        return this.readBytes(totalLength);
    }

    @Override
    public String readPadString(int totalLength) {
        return this.readString(totalLength);
    }

    @Override
    public String readPadStringAndRightTrim(int totalLength) {
        String string = BytesUtils.toStringAndRightTrim(this.buffer, this.offset, totalLength);
        this.offset += totalLength;
        return string;
    }

    @Override
    public byte[] readPrefixedBytes() {
        int size = this.readSVInt();
        if (size == -1) {
            return null;
        }
        if (size == 0) {
            return EMPTY;
        }
        return this.readBytes(size);
    }

    @Override
    public byte[] read2PrefixedBytes() {
        short size = this.readShort();
        if (size == -1) {
            return null;
        }
        if (size == 0) {
            return EMPTY;
        }
        return this.readBytes(size);
    }

    @Override
    public byte[] read4PrefixedBytes() {
        int size = this.readInt();
        if (size == -1) {
            return null;
        }
        if (size == 0) {
            return EMPTY;
        }
        return this.readBytes(size);
    }

    private byte[] readBytes(int size) {
        byte[] b = new byte[size];
        System.arraycopy(this.buffer, this.offset, b, 0, size);
        this.offset += size;
        return b;
    }

    @Override
    public String readPrefixedString() {
        int size = this.readSVInt();
        if (size == -1) {
            return null;
        }
        if (size == 0) {
            return "";
        }
        return this.readString(size);
    }

    @Override
    public String read2PrefixedString() {
        short size = this.readShort();
        if (size == -1) {
            return null;
        }
        if (size == 0) {
            return "";
        }
        return this.readString(size);
    }

    @Override
    public String read4PrefixedString() {
        int size = this.readInt();
        if (size == -1) {
            return null;
        }
        if (size == 0) {
            return "";
        }
        return this.readString(size);
    }

    private String readString(int size) {
        String s = this.newString(size);
        this.offset += size;
        return s;
    }

    private String newString(int size) {
        try {
            return new String(this.buffer, this.offset, size, UTF8);
        }
        catch (UnsupportedEncodingException ue) {
            return new String(this.buffer, this.offset, size, UTF8_CHARSET);
        }
    }

    @Override
    public byte[] getBuffer() {
        if (this.offset == this.buffer.length) {
            return this.buffer;
        }
        return this.copyBuffer();
    }

    @Override
    public byte[] copyBuffer() {
        byte[] copy = new byte[this.offset];
        System.arraycopy(this.buffer, 0, copy, 0, this.offset);
        return copy;
    }

    @Override
    public ByteBuffer wrapByteBuffer() {
        return ByteBuffer.wrap(this.buffer, 0, this.offset);
    }

    @Override
    public byte[] getInternalBuffer() {
        return this.buffer;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int remaining() {
        return this.buffer.length - this.offset;
    }

    @Override
    public boolean hasRemaining() {
        return this.offset < this.buffer.length;
    }
}

