/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.httpclient4.interceptor;

import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.httpclient4.HttpCallContext;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;

public class HttpClientExecuteMethodInternalInterceptor
implements AroundInterceptor {
    private boolean isHasCallbackParam;
    protected final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    protected final boolean isDebug = this.logger.isDebugEnabled();
    protected final TraceContext traceContext;
    private final InterceptorScope interceptorScope;

    public HttpClientExecuteMethodInternalInterceptor(boolean isHasCallbackParam, TraceContext context, InterceptorScope interceptorScope) {
        this.traceContext = context;
        this.interceptorScope = interceptorScope;
        this.isHasCallbackParam = isHasCallbackParam;
    }

    public void before(Object target, Object[] args) {
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        HttpResponse response;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, target.getClass().getName(), "", "internal", args);
        }
        if (!this.needGetStatusCode()) {
            return;
        }
        if (result != null && result instanceof HttpResponse && (response = (HttpResponse)result).getStatusLine() != null) {
            HttpCallContext context = new HttpCallContext();
            StatusLine statusLine = response.getStatusLine();
            if (statusLine != null) {
                context.setStatusCode(statusLine.getStatusCode());
                InterceptorScopeInvocation transaction = this.interceptorScope.getCurrentInvocation();
                Object attachment = this.getAttachment(transaction);
                if (attachment == null) {
                    transaction.setAttachment((Object)context);
                }
            }
        }
    }

    private boolean needGetStatusCode() {
        if (this.isHasCallbackParam) {
            return false;
        }
        Trace trace = this.traceContext.currentTraceObject();
        if (trace == null) {
            return false;
        }
        InterceptorScopeInvocation transaction = this.interceptorScope.getCurrentInvocation();
        Object attachment = this.getAttachment(transaction);
        return !(attachment instanceof HttpCallContext);
    }

    private Object getAttachment(InterceptorScopeInvocation invocation) {
        if (invocation == null) {
            return null;
        }
        return invocation.getAttachment();
    }
}

