/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.weblogic;

import com.navercorp.pinpoint.bootstrap.config.ExcludeMethodFilter;
import com.navercorp.pinpoint.bootstrap.config.ExcludePathFilter;
import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.config.SkipFilter;
import java.util.List;

public class WeblogicConfiguration {
    private final boolean enable;
    private final List<String> bootstrapMains;
    private final Filter<String> excludeUrlFilter;
    private final Filter<String> excludeProfileMethodFilter;
    private final String realIpHeader;
    private final String realIpEmptyValue;
    private final boolean traceRequestParam;
    private final boolean hidePinpointHeader;

    public WeblogicConfiguration(ProfilerConfig config) {
        this.enable = config.readBoolean("profiler.weblogic.enable", true);
        this.bootstrapMains = config.readList("profiler.weblogic.bootstrap.main");
        String weblogicExcludeURL = config.readString("profiler.weblogic.excludeurl", "");
        this.realIpHeader = config.readString("profiler.weblogic.realipheader", null);
        this.realIpEmptyValue = config.readString("profiler.weblogic.realipemptyvalue", null);
        this.excludeUrlFilter = !weblogicExcludeURL.isEmpty() ? new ExcludePathFilter(weblogicExcludeURL) : new SkipFilter();
        String excludeProfileMethod = config.readString("profiler.weblogic.excludemethod", "");
        this.excludeProfileMethodFilter = !excludeProfileMethod.isEmpty() ? new ExcludeMethodFilter(excludeProfileMethod) : new SkipFilter();
        this.traceRequestParam = config.readBoolean("profiler.weblogic.tracerequestparam", true);
        this.hidePinpointHeader = config.readBoolean("profiler.weblogic.hidepinpointheader", true);
    }

    public Filter<String> getExcludeUrlFilter() {
        return this.excludeUrlFilter;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public List<String> getWeblgoicBootstrapMains() {
        return this.bootstrapMains;
    }

    public boolean isTraceRequestParam() {
        return this.traceRequestParam;
    }

    public List<String> getBootstrapMains() {
        return this.bootstrapMains;
    }

    public Filter<String> getExcludeProfileMethodFilter() {
        return this.excludeProfileMethodFilter;
    }

    public String getRealIpHeader() {
        return this.realIpHeader;
    }

    public String getRealIpEmptyValue() {
        return this.realIpEmptyValue;
    }

    public boolean isHidePinpointHeader() {
        return this.hidePinpointHeader;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WeblogicConfiguration{");
        sb.append("enable=").append(this.enable);
        sb.append(", bootstrapMains=").append(this.bootstrapMains);
        sb.append(", excludeUrlFilter=").append(this.excludeUrlFilter);
        sb.append(", excludeProfileMethodFilter=").append(this.excludeProfileMethodFilter);
        sb.append(", realIpHeader='").append(this.realIpHeader).append('\'');
        sb.append(", realIpEmptyValue='").append(this.realIpEmptyValue).append('\'');
        sb.append(", traceRequestParam=").append(this.traceRequestParam);
        sb.append(", hidePinpointHeader=").append(this.hidePinpointHeader);
        sb.append('}');
        return sb.toString();
    }
}

