/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender.planer;

import com.navercorp.pinpoint.profiler.sender.PartitionedByteBufferLocator;
import com.navercorp.pinpoint.profiler.sender.SpanStreamSendData;
import com.navercorp.pinpoint.profiler.sender.SpanStreamSendDataFactory;
import com.navercorp.pinpoint.profiler.sender.SpanStreamSendDataMode;
import com.navercorp.pinpoint.profiler.sender.planer.SendDataPlaner;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseSerializer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSpanStreamSendDataPlaner
implements SendDataPlaner {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected PartitionedByteBufferLocator partitionedByteBufferLocator;
    private final SpanStreamSendDataFactory spanStreamSendDataFactory;

    public AbstractSpanStreamSendDataPlaner(PartitionedByteBufferLocator partitionedByteBufferLocator, SpanStreamSendDataFactory spanStreamSendDataFactory) {
        this.partitionedByteBufferLocator = partitionedByteBufferLocator;
        this.spanStreamSendDataFactory = spanStreamSendDataFactory;
    }

    @Override
    public Iterator<SpanStreamSendData> getSendDataIterator() throws IOException {
        return this.getSendDataIterator(this.spanStreamSendDataFactory.create());
    }

    @Override
    public Iterator<SpanStreamSendData> getSendDataIterator(SpanStreamSendData spanStreamSendData) throws IOException {
        return this.getSendDataIterator(spanStreamSendData, null);
    }

    @Override
    public Iterator<SpanStreamSendData> getSendDataIterator(SpanStreamSendData spanStreamSendData, HeaderTBaseSerializer serializer) throws IOException {
        int byteBufferCapacity;
        this.logger.info("process");
        ArrayList<SpanStreamSendData> spanStreamSendDataList = new ArrayList<SpanStreamSendData>();
        SpanStreamSendData currentSpanStreamSendData = spanStreamSendData;
        FlushMode mode = this.plan(spanStreamSendData);
        if (mode == FlushMode.FLUSH_FIRST) {
            spanStreamSendDataList.add(currentSpanStreamSendData);
            currentSpanStreamSendData.setFlushMode(SpanStreamSendDataMode.WAIT_BUFFER_AND_FLUSH);
            currentSpanStreamSendData = this.spanStreamSendDataFactory.create();
        }
        if (currentSpanStreamSendData.isAvailableBufferCapacity(byteBufferCapacity = this.partitionedByteBufferLocator.getTotalByteBufferCapacity())) {
            if (currentSpanStreamSendData.getAvailableGatheringComponentsCount() < 2) {
                currentSpanStreamSendData.setFlushMode();
            }
            currentSpanStreamSendData.addBuffer(this.partitionedByteBufferLocator.getByteBuffer(), serializer);
            spanStreamSendDataList.add(currentSpanStreamSendData);
        } else {
            int markFromPartitionIndex = 0;
            int markToPartitionIndex = -1;
            int flushBufferCapacity = 0;
            for (int i = 0; i < this.partitionedByteBufferLocator.getPartitionedCount(); ++i) {
                ByteBuffer addBuffer;
                int appendBufferSize = 0;
                if (!this.partitionedByteBufferLocator.isLastPartitionIndex(i)) {
                    appendBufferSize = this.getSpanChunkLength();
                }
                if (this.needFlush(currentSpanStreamSendData, flushBufferCapacity += this.partitionedByteBufferLocator.getByteBufferCapacity(i), appendBufferSize)) {
                    addBuffer = this.getByteBuffer(this.partitionedByteBufferLocator, markFromPartitionIndex, markToPartitionIndex);
                    if (addBuffer != null) {
                        ByteBuffer[] byteBufferArray = new ByteBuffer[]{addBuffer, this.getSpanChunkBuffer()};
                        currentSpanStreamSendData.addBuffer(byteBufferArray);
                    }
                    currentSpanStreamSendData.setFlushMode();
                    spanStreamSendDataList.add(currentSpanStreamSendData);
                    currentSpanStreamSendData = this.spanStreamSendDataFactory.create();
                    markFromPartitionIndex = i;
                    flushBufferCapacity = this.partitionedByteBufferLocator.getByteBufferCapacity(i);
                }
                markToPartitionIndex = i;
                if (!this.partitionedByteBufferLocator.isLastPartitionIndex(i)) continue;
                addBuffer = this.getByteBuffer(this.partitionedByteBufferLocator, markFromPartitionIndex, markToPartitionIndex);
                currentSpanStreamSendData.addBuffer(addBuffer, serializer);
                spanStreamSendDataList.add(currentSpanStreamSendData);
            }
        }
        return spanStreamSendDataList.iterator();
    }

    private FlushMode plan(SpanStreamSendData spanStreamSendData) {
        int byteBufferCapacity = this.partitionedByteBufferLocator.getTotalByteBufferCapacity();
        if (byteBufferCapacity < spanStreamSendData.getAvailableBufferCapacity()) {
            return FlushMode.NORMAL;
        }
        if (byteBufferCapacity < spanStreamSendData.getMaxBufferCapacity()) {
            return FlushMode.FLUSH_FIRST;
        }
        ByteBuffer spanChunkBuffer = this.getSpanChunkBuffer();
        for (int i = 0; i < this.partitionedByteBufferLocator.getPartitionedCount(); ++i) {
            int currentBufferCapacity = this.partitionedByteBufferLocator.getByteBufferCapacity(i);
            if (this.partitionedByteBufferLocator.isLastPartitionIndex(i)) {
                if (currentBufferCapacity <= spanStreamSendData.getMaxBufferCapacity()) continue;
                throw new IllegalStateException("BufferList has over size buffer. buffer length:" + currentBufferCapacity);
            }
            if (currentBufferCapacity + spanChunkBuffer.remaining() <= spanStreamSendData.getMaxBufferCapacity()) continue;
            throw new IllegalStateException("BufferList has over size buffer. buffer length:" + currentBufferCapacity + ", maxCapacity:" + spanStreamSendData.getMaxBufferCapacity());
        }
        return this.plan0(spanStreamSendData);
    }

    private FlushMode plan0(SpanStreamSendData spanStreamSendData) {
        int flushFirstModeChunkSize;
        int normalModeChunkSize = this.calculateWithUsingCurrentSendData(spanStreamSendData);
        if (normalModeChunkSize > (flushFirstModeChunkSize = this.calculateWithoutUsingCurrentSendData(spanStreamSendData))) {
            return FlushMode.FLUSH_FIRST;
        }
        return FlushMode.NORMAL;
    }

    private int calculateWithUsingCurrentSendData(SpanStreamSendData spanStreamSendData) {
        int chunkCount = 0;
        int availableBufferCapacity = spanStreamSendData.getAvailableBufferCapacity();
        return chunkCount + this.getNeedsChunkCount(spanStreamSendData, availableBufferCapacity);
    }

    private int calculateWithoutUsingCurrentSendData(SpanStreamSendData spanStreamSendData) {
        int chunkCount = 1;
        int availableBufferCapacity = spanStreamSendData.getMaxBufferCapacity();
        return chunkCount + this.getNeedsChunkCount(spanStreamSendData, availableBufferCapacity);
    }

    private int getNeedsChunkCount(SpanStreamSendData spanStreamSendData, int availableCurrentBufferCapacity) {
        int chunkCount = 1;
        int availableBufferCapacity = availableCurrentBufferCapacity;
        for (int i = 0; i < this.partitionedByteBufferLocator.getPartitionedCount(); ++i) {
            int partitionByteBufferCapacity = this.partitionedByteBufferLocator.getByteBufferCapacity(i);
            if (this.partitionedByteBufferLocator.isLastPartitionIndex(i)) {
                if (partitionByteBufferCapacity <= availableBufferCapacity) continue;
                ++chunkCount;
                continue;
            }
            if (partitionByteBufferCapacity + this.getSpanChunkLength() < availableBufferCapacity) {
                availableBufferCapacity -= partitionByteBufferCapacity;
                continue;
            }
            ++chunkCount;
            availableBufferCapacity = spanStreamSendData.getMaxBufferCapacity();
            availableBufferCapacity -= partitionByteBufferCapacity;
        }
        return chunkCount;
    }

    private boolean needFlush(SpanStreamSendData spanStreamSendData, int length, int delimiterBufferSize) {
        if (!spanStreamSendData.isAvailableBufferCapacity(length + delimiterBufferSize)) {
            return true;
        }
        int availableComponentsCount = 1;
        if (delimiterBufferSize > 0) {
            ++availableComponentsCount;
        }
        return !spanStreamSendData.isAvailableComponentsCount(availableComponentsCount);
    }

    private ByteBuffer getByteBuffer(PartitionedByteBufferLocator partitionedByteBufferLocator, int fromPartitionIndex, int toPartitionIndex) {
        if (toPartitionIndex == -1) {
            return null;
        }
        return partitionedByteBufferLocator.getByteBuffer(fromPartitionIndex, toPartitionIndex);
    }

    protected abstract int getSpanChunkLength();

    protected abstract ByteBuffer getSpanChunkBuffer();

    private static enum FlushMode {
        FLUSH_FIRST,
        NORMAL;

    }
}

