/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.plugin;

import com.navercorp.pinpoint.common.plugin.JarPlugin;
import com.navercorp.pinpoint.common.plugin.Plugin;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.plugin.ClassNameFilter;
import java.net.URL;
import java.util.jar.JarFile;

public class PluginConfig {
    public static final String PINPOINT_PLUGIN_PACKAGE = "Pinpoint-Plugin-Package";
    public static final String DEFAULT_PINPOINT_PLUGIN_PACKAGE_NAME = "com.navercorp.pinpoint.plugin";
    private final Plugin plugin;
    private final JarFile pluginJar;
    private String pluginJarURLExternalForm;
    private final ClassNameFilter pluginPackageFilter;

    public PluginConfig(Plugin plugin, ClassNameFilter pluginPackageFilter) {
        this.plugin = (Plugin)Assert.requireNonNull((Object)plugin, (String)"plugin must not be null");
        this.pluginPackageFilter = pluginPackageFilter;
        this.pluginJar = this.getJarFile(plugin);
    }

    private JarFile getJarFile(Plugin plugin) {
        if (plugin instanceof JarPlugin) {
            return ((JarPlugin)plugin).getJarFile();
        }
        throw new IllegalArgumentException("unsupported plugin " + plugin);
    }

    public URL getPluginJar() {
        return this.plugin.getURL();
    }

    public JarFile getPluginJarFile() {
        return this.pluginJar;
    }

    public String getPluginJarURLExternalForm() {
        if (this.pluginJarURLExternalForm == null) {
            this.pluginJarURLExternalForm = this.plugin.getURL().toExternalForm();
        }
        return this.pluginJarURLExternalForm;
    }

    public ClassNameFilter getPluginPackageFilter() {
        return this.pluginPackageFilter;
    }

    public String toString() {
        return "PluginConfig{pluginJar=" + this.plugin.getURL() + ", pluginJarURLExternalForm='" + this.pluginJarURLExternalForm + '\'' + ", pluginPackageFilter=" + this.pluginPackageFilter + '}';
    }
}

