/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.metadata;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.profiler.metadata.ApiMetaData;
import com.navercorp.pinpoint.profiler.metadata.ApiMetaDataService;
import com.navercorp.pinpoint.profiler.metadata.Result;
import com.navercorp.pinpoint.profiler.metadata.SimpleCache;
import com.navercorp.pinpoint.profiler.sender.EnhancedDataSender;

public class DefaultApiMetaDataService
implements ApiMetaDataService {
    private final SimpleCache<String> apiCache = new SimpleCache();
    private final EnhancedDataSender<Object> enhancedDataSender;

    public DefaultApiMetaDataService(EnhancedDataSender<Object> enhancedDataSender) {
        if (enhancedDataSender == null) {
            throw new NullPointerException("enhancedDataSender must not be null");
        }
        this.enhancedDataSender = enhancedDataSender;
    }

    @Override
    public int cacheApi(MethodDescriptor methodDescriptor) {
        String fullName = methodDescriptor.getFullName();
        Result result = this.apiCache.put(fullName);
        methodDescriptor.setApiId(result.getId());
        if (result.isNewValue()) {
            ApiMetaData apiMetadata = new ApiMetaData(result.getId(), methodDescriptor.getApiDescriptor());
            apiMetadata.setLine(methodDescriptor.getLineNumber());
            apiMetadata.setType(methodDescriptor.getType());
            this.enhancedDataSender.request(apiMetadata);
        }
        return result.getId();
    }
}

