/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.scanner;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.instrument.scanner.Scanner;
import java.io.InputStream;

public class ClassLoaderScanner
implements Scanner {
    private final ClassLoader classLoader;

    public ClassLoaderScanner(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        this.classLoader = classLoader;
    }

    @Override
    public boolean exist(String fileName) {
        Assert.requireNonNull((Object)fileName, (String)"fileName must not be null");
        return this.classLoader.getResource(fileName) != null;
    }

    @Override
    public InputStream openStream(String fileName) {
        Assert.requireNonNull((Object)fileName, (String)"fileName must not be null");
        return this.classLoader.getResourceAsStream(fileName);
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "ClassLoaderScanner{classLoader=" + this.classLoader + '}';
    }
}

