/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument;

import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.interceptor.Interceptor;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.instrument.EngineComponent;
import com.navercorp.pinpoint.profiler.instrument.ScopeFactory;
import com.navercorp.pinpoint.profiler.instrument.interceptor.InterceptorDefinition;
import com.navercorp.pinpoint.profiler.instrument.interceptor.InterceptorDefinitionFactory;
import com.navercorp.pinpoint.profiler.interceptor.registry.InterceptorRegistryBinder;
import com.navercorp.pinpoint.profiler.metadata.ApiMetaDataService;
import com.navercorp.pinpoint.profiler.objectfactory.ObjectBinderFactory;

public class DefaultEngineComponent
implements EngineComponent {
    private final ObjectBinderFactory objectBinderFactory;
    private final InterceptorRegistryBinder interceptorRegistryBinder;
    private final InterceptorDefinitionFactory interceptorDefinitionFactory;
    private final Provider<ApiMetaDataService> apiMetaDataServiceProvider;
    private final ScopeFactory scopeFactory;

    public DefaultEngineComponent(ObjectBinderFactory objectBinderFactory, InterceptorRegistryBinder interceptorRegistryBinder, InterceptorDefinitionFactory interceptorDefinitionFactory, Provider<ApiMetaDataService> apiMetaDataServiceProvider, ScopeFactory scopeFactory) {
        this.objectBinderFactory = (ObjectBinderFactory)Assert.requireNonNull((Object)objectBinderFactory, (String)"objectBinderFactory must not be null");
        this.interceptorRegistryBinder = (InterceptorRegistryBinder)Assert.requireNonNull((Object)interceptorRegistryBinder, (String)"interceptorRegistryBinder must not be null");
        this.interceptorDefinitionFactory = (InterceptorDefinitionFactory)Assert.requireNonNull((Object)interceptorDefinitionFactory, (String)"interceptorDefinitionFactory must not be null");
        this.apiMetaDataServiceProvider = (Provider)Assert.requireNonNull(apiMetaDataServiceProvider, (String)"apiMetaDataService must not be null");
        this.scopeFactory = (ScopeFactory)Assert.requireNonNull((Object)scopeFactory, (String)"scopeFactory must not be null");
    }

    @Override
    public ScopeFactory getScopeFactory() {
        return this.scopeFactory;
    }

    @Override
    public InterceptorDefinition createInterceptorDefinition(Class<?> interceptorClazz) {
        return this.interceptorDefinitionFactory.createInterceptorDefinition(interceptorClazz);
    }

    @Override
    public ObjectBinderFactory getObjectBinderFactory() {
        return this.objectBinderFactory;
    }

    @Override
    public int addInterceptor(Interceptor interceptor) {
        return this.interceptorRegistryBinder.getInterceptorRegistryAdaptor().addInterceptor(interceptor);
    }

    @Override
    public int cacheApi(MethodDescriptor methodDescriptor) {
        ApiMetaDataService apiMetaDataService = (ApiMetaDataService)this.apiMetaDataServiceProvider.get();
        return apiMetaDataService.cacheApi(methodDescriptor);
    }
}

