/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.instrument.DynamicTransformTrigger;
import com.navercorp.pinpoint.profiler.DynamicTransformService;
import com.navercorp.pinpoint.profiler.DynamicTransformerRegistry;
import java.lang.instrument.Instrumentation;

public class DynamicTransformTriggerProvider
implements Provider<DynamicTransformTrigger> {
    private final Instrumentation instrumentation;
    private final DynamicTransformerRegistry dynamicTransformerRegistry;

    @Inject
    public DynamicTransformTriggerProvider(Instrumentation instrumentation, DynamicTransformerRegistry dynamicTransformerRegistry) {
        if (instrumentation == null) {
            throw new NullPointerException("instrumentation must not be null");
        }
        if (dynamicTransformerRegistry == null) {
            throw new NullPointerException("dynamicTransformerRegistry must not be null");
        }
        this.instrumentation = instrumentation;
        this.dynamicTransformerRegistry = dynamicTransformerRegistry;
    }

    public DynamicTransformTrigger get() {
        return new DynamicTransformService(this.instrumentation, this.dynamicTransformerRegistry);
    }
}

