/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.instrument.DynamicTransformTrigger;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.DefaultClassFileTransformerDispatcher;
import com.navercorp.pinpoint.profiler.DynamicTransformerRegistry;
import com.navercorp.pinpoint.profiler.instrument.InstrumentEngine;
import com.navercorp.pinpoint.profiler.instrument.transformer.BaseTransformerRegistry;
import com.navercorp.pinpoint.profiler.instrument.transformer.BypassLambdaClassFileResolver;
import com.navercorp.pinpoint.profiler.instrument.transformer.DebugTransformerRegistry;
import com.navercorp.pinpoint.profiler.instrument.transformer.DefaultLambdaClassFileResolver;
import com.navercorp.pinpoint.profiler.instrument.transformer.DefaultTransformerRegistry;
import com.navercorp.pinpoint.profiler.instrument.transformer.LambdaClassFileResolver;
import com.navercorp.pinpoint.profiler.instrument.transformer.MatchableTransformerRegistry;
import com.navercorp.pinpoint.profiler.instrument.transformer.TransformerRegistry;
import com.navercorp.pinpoint.profiler.plugin.MatchableClassFileTransformer;
import com.navercorp.pinpoint.profiler.plugin.PluginContextLoadResult;
import java.lang.instrument.ClassFileTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassFileTransformerProvider
implements Provider<ClassFileTransformer> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ProfilerConfig profilerConfig;
    private final PluginContextLoadResult pluginContextLoadResult;
    private final InstrumentEngine instrumentEngine;
    private final DynamicTransformTrigger dynamicTransformTrigger;
    private final DynamicTransformerRegistry dynamicTransformerRegistry;

    @Inject
    public ClassFileTransformerProvider(ProfilerConfig profilerConfig, InstrumentEngine instrumentEngine, PluginContextLoadResult pluginContextLoadResult, DynamicTransformTrigger dynamicTransformTrigger, DynamicTransformerRegistry dynamicTransformerRegistry) {
        this.profilerConfig = (ProfilerConfig)Assert.requireNonNull((Object)profilerConfig, (String)"profilerConfig must not be null");
        this.instrumentEngine = (InstrumentEngine)Assert.requireNonNull((Object)instrumentEngine, (String)"instrumentEngine must not be null");
        this.pluginContextLoadResult = (PluginContextLoadResult)Assert.requireNonNull((Object)pluginContextLoadResult, (String)"pluginContextLoadResult must not be null");
        this.dynamicTransformTrigger = (DynamicTransformTrigger)Assert.requireNonNull((Object)dynamicTransformTrigger, (String)"dynamicTransformTrigger must not be null");
        this.dynamicTransformerRegistry = (DynamicTransformerRegistry)Assert.requireNonNull((Object)dynamicTransformerRegistry, (String)"dynamicTransformerRegistry must not be null");
    }

    public ClassFileTransformer get() {
        LambdaClassFileResolver lambdaClassFileResolver = this.newLambdaClassFileResolver(this.profilerConfig);
        BaseTransformerRegistry baseTransformerRegistry = this.newDefaultTransformerRegistry();
        TransformerRegistry transformerRegistry = this.setupTransformerRegistry(baseTransformerRegistry, this.pluginContextLoadResult);
        DebugTransformerRegistry debugTransformerRegistry = new DebugTransformerRegistry(this.profilerConfig, this.instrumentEngine, this.dynamicTransformTrigger);
        return new DefaultClassFileTransformerDispatcher(transformerRegistry, debugTransformerRegistry, this.dynamicTransformerRegistry, lambdaClassFileResolver);
    }

    private LambdaClassFileResolver newLambdaClassFileResolver(ProfilerConfig profilerConfig) {
        if (profilerConfig.isSupportLambdaExpressions()) {
            return new DefaultLambdaClassFileResolver();
        }
        return new BypassLambdaClassFileResolver();
    }

    private BaseTransformerRegistry newDefaultTransformerRegistry() {
        if (this.profilerConfig.isInstrumentMatcherEnable()) {
            return new MatchableTransformerRegistry(this.profilerConfig);
        }
        return new DefaultTransformerRegistry();
    }

    private TransformerRegistry setupTransformerRegistry(BaseTransformerRegistry registry, PluginContextLoadResult pluginContexts) {
        Assert.requireNonNull((Object)registry, (String)"registry must not be null");
        Assert.requireNonNull((Object)pluginContexts, (String)"pluginContexts must not be null");
        for (ClassFileTransformer transformer : pluginContexts.getClassFileTransformer()) {
            if (transformer instanceof MatchableClassFileTransformer) {
                MatchableClassFileTransformer t = (MatchableClassFileTransformer)transformer;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Registering class file transformer {} for {} ", (Object)t, (Object)t.getMatcher());
                }
                try {
                    registry.addTransformer(t.getMatcher(), t);
                }
                catch (Exception e) {
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn("Failed to add transformer {}", (Object)transformer, (Object)e);
                }
                continue;
            }
            if (!this.logger.isWarnEnabled()) continue;
            this.logger.warn("Ignore class file transformer {}", (Object)transformer);
        }
        return registry;
    }
}

