/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.AgentInfoSender;
import com.navercorp.pinpoint.profiler.context.ServerMetaDataRegistryService;
import com.navercorp.pinpoint.profiler.sender.EnhancedDataSender;
import com.navercorp.pinpoint.profiler.util.AgentInfoFactory;

public class AgentInfoSenderProvider
implements Provider<AgentInfoSender> {
    private final ProfilerConfig profilerConfig;
    private final Provider<EnhancedDataSender<Object>> enhancedDataSenderProvider;
    private final Provider<AgentInfoFactory> agentInfoFactoryProvider;
    private final ServerMetaDataRegistryService serverMetaDataRegistryService;

    @Inject
    public AgentInfoSenderProvider(ProfilerConfig profilerConfig, Provider<EnhancedDataSender<Object>> enhancedDataSenderProvider, Provider<AgentInfoFactory> agentInfoFactoryProvider, ServerMetaDataRegistryService serverMetaDataRegistryService) {
        this.profilerConfig = (ProfilerConfig)Assert.requireNonNull((Object)profilerConfig, (String)"profilerConfig must not be null");
        this.enhancedDataSenderProvider = (Provider)Assert.requireNonNull(enhancedDataSenderProvider, (String)"enhancedDataSenderProvider must not be null");
        this.agentInfoFactoryProvider = (Provider)Assert.requireNonNull(agentInfoFactoryProvider, (String)"agentInfoFactoryProvider must not be null");
        this.serverMetaDataRegistryService = (ServerMetaDataRegistryService)Assert.requireNonNull((Object)serverMetaDataRegistryService, (String)"serverMetaDataRegistryService must not be null");
    }

    public AgentInfoSender get() {
        EnhancedDataSender enhancedDataSender = (EnhancedDataSender)this.enhancedDataSenderProvider.get();
        AgentInfoFactory agentInfoFactory = (AgentInfoFactory)this.agentInfoFactoryProvider.get();
        final AgentInfoSender agentInfoSender = new AgentInfoSender.Builder(enhancedDataSender, agentInfoFactory).sendInterval(this.profilerConfig.getAgentInfoSendRetryInterval()).build();
        this.serverMetaDataRegistryService.addListener(new ServerMetaDataRegistryService.OnChangeListener(){

            @Override
            public void onServerMetaDataChange() {
                agentInfoSender.refresh();
            }
        });
        return agentInfoSender;
    }
}

