/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.active;

import com.navercorp.pinpoint.common.trace.BaseHistogramSchema;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceHandle;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceHistogram;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceRepository;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceSnapshot;
import com.navercorp.pinpoint.profiler.context.active.EmptyActiveTraceHistogram;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.monitor.metric.response.ResponseTimeCollector;
import java.util.Collections;
import java.util.List;

public class EmptyActiveTraceRepository
implements ActiveTraceRepository {
    private final ResponseTimeCollector responseTimeCollector;
    private final ActiveTraceHistogram emptyActiveTraceHistogram = new EmptyActiveTraceHistogram(BaseHistogramSchema.NORMAL_SCHEMA);

    public EmptyActiveTraceRepository(ResponseTimeCollector responseTimeCollector) {
        this.responseTimeCollector = (ResponseTimeCollector)Assert.requireNonNull((Object)responseTimeCollector, (String)"responseTimeCollector must not be null");
    }

    @Override
    public ActiveTraceHistogram getActiveTraceHistogram(long timeStamp) {
        return this.emptyActiveTraceHistogram;
    }

    @Override
    public List<Long> getThreadIdList() {
        return null;
    }

    @Override
    public List<ActiveTraceSnapshot> snapshot() {
        return Collections.emptyList();
    }

    @Override
    public ActiveTraceHandle register(TraceRoot traceRoot) {
        Assert.requireNonNull((Object)traceRoot, (String)"traceRoot must not be null");
        return new EmptyActiveTraceHandle(traceRoot.getTraceStartTime());
    }

    @Override
    public ActiveTraceHandle register(long localTransactionId, long startTime, long threadId) {
        return new EmptyActiveTraceHandle(startTime);
    }

    private void remove(long startTime, long purgeTime) {
        long responseTime = purgeTime - startTime;
        this.responseTimeCollector.add(responseTime);
    }

    private class EmptyActiveTraceHandle
    implements ActiveTraceHandle {
        private final long startTime;

        public EmptyActiveTraceHandle(long startTime) {
            this.startTime = startTime;
        }

        @Override
        public void purge(long purgeTime) {
            EmptyActiveTraceRepository.this.remove(this.startTime, purgeTime);
        }
    }
}

