/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.java9.module;

import com.navercorp.pinpoint.bootstrap.java9.module.ModuleException;
import com.navercorp.pinpoint.bootstrap.java9.module.RedefineModuleUtils;
import com.navercorp.pinpoint.bootstrap.module.JavaModule;
import java.lang.instrument.Instrumentation;
import java.util.Map;
import java.util.Set;

public class Java9Module
implements JavaModule {
    private final Instrumentation instrumentation;
    private final Module module;

    Java9Module(Instrumentation instrumentation, Module module) {
        if (instrumentation == null) {
            throw new NullPointerException("instrumentation must not be null");
        }
        this.instrumentation = instrumentation;
        this.module = module;
    }

    public boolean isSupported() {
        return true;
    }

    public boolean isNamed() {
        return this.module.isNamed();
    }

    public String getName() {
        return this.module.getName();
    }

    public void addReads(JavaModule targetJavaModule) {
        Java9Module target = this.checkJavaModule(targetJavaModule);
        Set<Module> readModules = Set.of(target.module);
        RedefineModuleUtils.addReads(this.instrumentation, this.module, readModules);
    }

    public void addExports(String packageName, JavaModule targetJavaModule) {
        if (packageName == null) {
            throw new NullPointerException("packageName must not be null");
        }
        Java9Module target = this.checkJavaModule(targetJavaModule);
        Map<String, Set<Module>> extraModules = Map.of(packageName, Set.of(target.module));
        RedefineModuleUtils.addExports(this.instrumentation, this.module, extraModules);
    }

    private Java9Module checkJavaModule(JavaModule targetJavaModule) {
        if (targetJavaModule == null) {
            throw new NullPointerException("targetJavaModule must not be null");
        }
        if (targetJavaModule instanceof Java9Module) {
            return (Java9Module)targetJavaModule;
        }
        throw new ModuleException("invalid JavaModule: " + targetJavaModule.getClass());
    }

    public void addOpens(String packageName, JavaModule javaModule) {
        if (packageName == null) {
            throw new NullPointerException("packageName must not be null");
        }
        Java9Module target = this.checkJavaModule(javaModule);
        Map<String, Set<Module>> extraOpens = Map.of(packageName, Set.of(target.module));
        RedefineModuleUtils.addOpens(this.instrumentation, this.module, extraOpens);
    }

    public void addUses(Class<?> target) {
        if (target == null) {
            throw new NullPointerException("target must not be null");
        }
        Set<Class<?>> extraUses = Set.of(target);
        RedefineModuleUtils.addUses(this.instrumentation, this.module, extraUses);
    }

    public boolean isExported(String packageName, JavaModule targetJavaModule) {
        if (packageName == null) {
            throw new NullPointerException("packageName must not be null");
        }
        Java9Module target = this.checkJavaModule(targetJavaModule);
        return this.module.isExported(packageName, target.module);
    }

    public boolean isOpen(String packageName, JavaModule targetJavaModule) {
        if (packageName == null) {
            throw new NullPointerException("packageName must not be null");
        }
        Java9Module target = this.checkJavaModule(targetJavaModule);
        return this.module.isOpen(packageName, target.module);
    }

    public boolean canRead(JavaModule targetJavaModule) {
        Java9Module target = this.checkJavaModule(targetJavaModule);
        return this.module.canRead(target.module);
    }

    public boolean canRead(Class<?> targetClazz) {
        return this.module.canUse(targetClazz);
    }

    public ClassLoader getClassLoader() {
        return this.module.getClassLoader();
    }

    public String toString() {
        return this.module.toString();
    }
}

