/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.vertx;

import com.navercorp.pinpoint.bootstrap.config.ExcludeMethodFilter;
import com.navercorp.pinpoint.bootstrap.config.ExcludePathFilter;
import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.config.SkipFilter;

public class VertxHttpServerConfig {
    private final boolean traceRequestParam;
    private final Filter<String> excludeUrlFilter;
    private final String realIpHeader;
    private final String realIpEmptyValue;
    private final Filter<String> excludeProfileMethodFilter;
    private final boolean hidePinpointHeader;
    private final String requestHandlerMethodName;

    public VertxHttpServerConfig(ProfilerConfig config) {
        if (config == null) {
            throw new NullPointerException("config must not be null");
        }
        this.traceRequestParam = config.readBoolean("profiler.vertx.http.server.tracerequestparam", true);
        String tomcatExcludeURL = config.readString("profiler.vertx.http.server.excludeurl", "");
        this.excludeUrlFilter = !tomcatExcludeURL.isEmpty() ? new ExcludePathFilter(tomcatExcludeURL) : new SkipFilter();
        this.realIpHeader = config.readString("profiler.vertx.http.server.realipheader", null);
        this.realIpEmptyValue = config.readString("profiler.vertx.http.server.realipemptyvalue", null);
        String tomcatExcludeProfileMethod = config.readString("profiler.vertx.http.server.excludemethod", "");
        this.excludeProfileMethodFilter = !tomcatExcludeProfileMethod.isEmpty() ? new ExcludeMethodFilter(tomcatExcludeProfileMethod) : new SkipFilter();
        this.hidePinpointHeader = config.readBoolean("profiler.vertx.http.server.hidepinpointheader", true);
        this.requestHandlerMethodName = config.readString("profiler.vertx.http.server.request-handler.method.name", "io.vertx.ext.web.impl.RouterImpl.accept");
    }

    public boolean isTraceRequestParam() {
        return this.traceRequestParam;
    }

    public Filter<String> getExcludeUrlFilter() {
        return this.excludeUrlFilter;
    }

    public String getRealIpHeader() {
        return this.realIpHeader;
    }

    public String getRealIpEmptyValue() {
        return this.realIpEmptyValue;
    }

    public Filter<String> getExcludeProfileMethodFilter() {
        return this.excludeProfileMethodFilter;
    }

    public boolean isHidePinpointHeader() {
        return this.hidePinpointHeader;
    }

    public String getRequestHandlerMethodName() {
        return this.requestHandlerMethodName;
    }
}

