/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.vertx;

import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.ParameterExtractor;
import com.navercorp.pinpoint.common.util.Assert;
import io.vertx.core.http.HttpServerRequest;

public class MethodFilterExtractor
implements ParameterExtractor<HttpServerRequest> {
    private final Filter<String> excludeProfileMethodFilter;
    private final ParameterExtractor<HttpServerRequest> delegate;

    public MethodFilterExtractor(Filter<String> excludeProfileMethodFilter, ParameterExtractor<HttpServerRequest> delegate) {
        this.excludeProfileMethodFilter = (Filter)Assert.requireNonNull(excludeProfileMethodFilter, (String)"excludeProfileMethodFilter must not be null");
        this.delegate = (ParameterExtractor)Assert.requireNonNull(delegate, (String)"delegate must not be null");
    }

    public String extractParameter(HttpServerRequest httpServletRequest) {
        if (this.excludeProfileMethodFilter.filter((Object)httpServletRequest.method().toString())) {
            return null;
        }
        return this.delegate.extractParameter((Object)httpServletRequest);
    }
}

