/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.tomcat.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.ServletRequestListenerInterceptorHelper;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.ParameterRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.RemoteAddressResolverFactory;
import com.navercorp.pinpoint.plugin.tomcat.TomcatConfig;
import com.navercorp.pinpoint.plugin.tomcat.TomcatConstants;
import com.navercorp.pinpoint.plugin.tomcat.common.servlet.util.ArgumentValidator;
import com.navercorp.pinpoint.plugin.tomcat.common.servlet.util.HttpServletRequestAdaptor;
import com.navercorp.pinpoint.plugin.tomcat.common.servlet.util.ParameterRecorderFactory;
import com.navercorp.pinpoint.plugin.tomcat.common.servlet.util.ServletArgumentValidator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.Response;

public class StandardHostValveInvokeInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final boolean isInfo = this.logger.isInfoEnabled();
    private final MethodDescriptor methodDescriptor;
    private final ArgumentValidator argumentValidator;
    private final ServletRequestListenerInterceptorHelper<HttpServletRequest> servletRequestListenerInterceptorHelper;

    public StandardHostValveInvokeInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        this.methodDescriptor = descriptor;
        this.argumentValidator = new ServletArgumentValidator(this.logger, 0, HttpServletRequest.class, 1, HttpServletResponse.class);
        TomcatConfig config = new TomcatConfig(traceContext.getProfilerConfig());
        HttpServletRequestAdaptor requestAdaptor = new HttpServletRequestAdaptor();
        requestAdaptor = RemoteAddressResolverFactory.wrapRealIpSupport((RequestAdaptor)requestAdaptor, (String)config.getRealIpHeader(), (String)config.getRealIpEmptyValue());
        ParameterRecorder<HttpServletRequest> parameterRecorder = ParameterRecorderFactory.newParameterRecorderFactory(config.getExcludeProfileMethodFilter(), config.isTraceRequestParam());
        this.servletRequestListenerInterceptorHelper = new ServletRequestListenerInterceptorHelper(TomcatConstants.TOMCAT, traceContext, (RequestAdaptor)requestAdaptor, config.getExcludeUrlFilter(), parameterRecorder);
    }

    public void before(Object target, Object[] args) {
        block6: {
            if (this.isDebug) {
                this.logger.beforeInterceptor(target, args);
            }
            if (!this.argumentValidator.validate(args)) {
                return;
            }
            try {
                HttpServletRequest request = (HttpServletRequest)args[0];
                Trace asyncTrace = (Trace)request.getAttribute("com.navercorp.pinpoint.trace");
                if (asyncTrace != null) {
                    if (this.isDebug) {
                        this.logger.debug("Skip async servlet request event.");
                    }
                    return;
                }
                this.servletRequestListenerInterceptorHelper.initialized((Object)request, TomcatConstants.TOMCAT_METHOD, this.methodDescriptor);
            }
            catch (Throwable t) {
                if (!this.isInfo) break block6;
                this.logger.info("Failed to servlet request event handle.", t);
            }
        }
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        block4: {
            if (this.isDebug) {
                this.logger.afterInterceptor(target, args, result, throwable);
            }
            if (!this.argumentValidator.validate(args)) {
                return;
            }
            try {
                HttpServletRequest request = (HttpServletRequest)args[0];
                HttpServletResponse response = (HttpServletResponse)args[1];
                int statusCode = this.getStatusCode(response);
                this.servletRequestListenerInterceptorHelper.destroyed((Object)request, throwable, statusCode);
            }
            catch (Throwable t) {
                if (!this.isInfo) break block4;
                this.logger.info("Failed to servlet request event handle.", t);
            }
        }
    }

    private int getStatusCode(HttpServletResponse response) {
        try {
            if (response instanceof Response) {
                Response r = (Response)response;
                return r.getStatus();
            }
            response.getStatus();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }
}

