/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.mongo;

import com.navercorp.pinpoint.bootstrap.instrument.ClassFilters;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilter;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.bootstrap.plugin.util.InstrumentUtils;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.mongo.MongoConfig;
import com.navercorp.pinpoint.plugin.mongo.MongoConstants;
import java.security.ProtectionDomain;
import java.util.List;

public class MongoPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private static final String MONGO_SCOPE = "MONGO_JAVA_DRIVER";
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        MongoConfig config = new MongoConfig(context.getConfig());
        if (!config.isEnable()) {
            this.logger.info("MongoDB plugin is not executed because plugin enable value is false.");
            return;
        }
        this.addFilterTransformer();
        this.addUpdatesTransformer();
        this.addConnectionTransformer3_0_X();
        this.addConnectionTransformer3_7_X();
        this.addConnectionTransformer3_8_X();
        this.addSessionTransformer3_0_X(config);
        this.addSessionTransformer3_7_X(config);
    }

    private void addConnectionTransformer3_0_X() {
        this.transformTemplate.transform("com.mongodb.Mongo", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (!target.isInterceptable()) {
                    return null;
                }
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                InstrumentMethod connect = InstrumentUtils.findConstructor((InstrumentClass)target, (String[])new String[]{"com.mongodb.connection.Cluster", "com.mongodb.MongoClientOptions", "java.util.List"});
                connect.addScopedInterceptor("com.navercorp.pinpoint.plugin.mongo.interceptor.MongoDriverConnectInterceptor3_0", MongoPlugin.MONGO_SCOPE, ExecutionPolicy.BOUNDARY);
                InstrumentMethod close = InstrumentUtils.findMethod((InstrumentClass)target, (String)"close", (String[])new String[0]);
                close.addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.ConnectionCloseInterceptor", MongoPlugin.MONGO_SCOPE);
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("com.mongodb.MongoClient", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (!target.isInterceptable()) {
                    return null;
                }
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                InstrumentMethod connectDeliver = InstrumentUtils.findMethod((InstrumentClass)target, (String)"getDatabase", (String[])new String[]{"java.lang.String"});
                connectDeliver.addScopedInterceptor("com.navercorp.pinpoint.plugin.mongo.interceptor.MongoDriverGetDatabaseInterceptor", MongoPlugin.MONGO_SCOPE, ExecutionPolicy.BOUNDARY);
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("com.mongodb.MongoDatabaseImpl", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (!target.isInterceptable()) {
                    return null;
                }
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                InstrumentMethod connect = InstrumentUtils.findMethod((InstrumentClass)target, (String)"getCollection", (String[])new String[]{"java.lang.String", "java.lang.Class"});
                connect.addScopedInterceptor("com.navercorp.pinpoint.plugin.mongo.interceptor.MongoDriverGetCollectionInterceptor", MongoPlugin.MONGO_SCOPE, ExecutionPolicy.BOUNDARY);
                InstrumentMethod getReadPreference = InstrumentUtils.findMethod((InstrumentClass)target, (String)"withReadPreference", (String[])new String[]{"com.mongodb.ReadPreference"});
                getReadPreference.addScopedInterceptor("com.navercorp.pinpoint.plugin.mongo.interceptor.MongoReadPreferenceInterceptor", MongoPlugin.MONGO_SCOPE, ExecutionPolicy.BOUNDARY);
                InstrumentMethod getWriteConcern = InstrumentUtils.findMethod((InstrumentClass)target, (String)"withWriteConcern", (String[])new String[]{"com.mongodb.WriteConcern"});
                getWriteConcern.addScopedInterceptor("com.navercorp.pinpoint.plugin.mongo.interceptor.MongoWriteConcernInterceptor", MongoPlugin.MONGO_SCOPE, ExecutionPolicy.BOUNDARY);
                return target.toBytecode();
            }
        });
    }

    private void addConnectionTransformer3_7_X() {
        this.transformTemplate.transform("com.mongodb.client.MongoClients", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (!target.isInterceptable()) {
                    return null;
                }
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                InstrumentMethod connect = InstrumentUtils.findMethod((InstrumentClass)target, (String)"create", (String[])new String[]{"com.mongodb.MongoClientSettings", "com.mongodb.MongoDriverInformation"});
                connect.addScopedInterceptor("com.navercorp.pinpoint.plugin.mongo.interceptor.MongoDriverConnectInterceptor3_7", MongoPlugin.MONGO_SCOPE, ExecutionPolicy.BOUNDARY);
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("com.mongodb.client.MongoClientImpl", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (!target.isInterceptable()) {
                    return null;
                }
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                InstrumentMethod connect = InstrumentUtils.findMethod((InstrumentClass)target, (String)"getDatabase", (String[])new String[]{"java.lang.String"});
                connect.addScopedInterceptor("com.navercorp.pinpoint.plugin.mongo.interceptor.MongoDriverGetDatabaseInterceptor", MongoPlugin.MONGO_SCOPE, ExecutionPolicy.BOUNDARY);
                InstrumentMethod close = InstrumentUtils.findMethod((InstrumentClass)target, (String)"close", (String[])new String[0]);
                close.addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.ConnectionCloseInterceptor", MongoPlugin.MONGO_SCOPE);
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("com.mongodb.client.internal.MongoDatabaseImpl", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (!target.isInterceptable()) {
                    return null;
                }
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                InstrumentMethod connect = InstrumentUtils.findMethod((InstrumentClass)target, (String)"getCollection", (String[])new String[]{"java.lang.String", "java.lang.Class"});
                connect.addScopedInterceptor("com.navercorp.pinpoint.plugin.mongo.interceptor.MongoDriverGetCollectionInterceptor", MongoPlugin.MONGO_SCOPE, ExecutionPolicy.BOUNDARY);
                InstrumentMethod getReadPreference = InstrumentUtils.findMethod((InstrumentClass)target, (String)"withReadPreference", (String[])new String[]{"com.mongodb.ReadPreference"});
                getReadPreference.addScopedInterceptor("com.navercorp.pinpoint.plugin.mongo.interceptor.MongoReadPreferenceInterceptor", MongoPlugin.MONGO_SCOPE, ExecutionPolicy.BOUNDARY);
                InstrumentMethod getWriteConcern = InstrumentUtils.findMethod((InstrumentClass)target, (String)"withWriteConcern", (String[])new String[]{"com.mongodb.WriteConcern"});
                getWriteConcern.addScopedInterceptor("com.navercorp.pinpoint.plugin.mongo.interceptor.MongoWriteConcernInterceptor", MongoPlugin.MONGO_SCOPE, ExecutionPolicy.BOUNDARY);
                return target.toBytecode();
            }
        });
    }

    private void addConnectionTransformer3_8_X() {
        this.transformTemplate.transform("com.mongodb.client.internal.MongoClientImpl", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (!target.isInterceptable()) {
                    return null;
                }
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                InstrumentMethod connect = InstrumentUtils.findMethod((InstrumentClass)target, (String)"getDatabase", (String[])new String[]{"java.lang.String"});
                connect.addScopedInterceptor("com.navercorp.pinpoint.plugin.mongo.interceptor.MongoDriverGetDatabaseInterceptor", MongoPlugin.MONGO_SCOPE, ExecutionPolicy.BOUNDARY);
                InstrumentMethod close = InstrumentUtils.findMethod((InstrumentClass)target, (String)"close", (String[])new String[0]);
                close.addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.ConnectionCloseInterceptor", MongoPlugin.MONGO_SCOPE);
                return target.toBytecode();
            }
        });
    }

    private void addSessionTransformer3_0_X(final MongoConfig config) {
        TransformCallback transformCallback = new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (!target.isInterceptable()) {
                    return null;
                }
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.chain((MethodFilter[])new MethodFilter[]{MethodFilters.modifier((int)1), MethodFilters.name((String[])MongoPlugin.this.getMethodlistR3_0_x())}))) {
                    method.addScopedInterceptor("com.navercorp.pinpoint.plugin.mongo.interceptor.MongoRSessionInterceptor", VarArgs.va((Object[])new Object[]{config.isCollectJson(), config.istraceBsonBindValue()}), MongoPlugin.MONGO_SCOPE, ExecutionPolicy.BOUNDARY);
                }
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.chain((MethodFilter[])new MethodFilter[]{MethodFilters.modifier((int)1), MethodFilters.name((String[])MongoPlugin.this.getMethodlistCUD3_0_x())}))) {
                    method.addScopedInterceptor("com.navercorp.pinpoint.plugin.mongo.interceptor.MongoCUDSessionInterceptor", VarArgs.va((Object[])new Object[]{config.isCollectJson(), config.istraceBsonBindValue()}), MongoPlugin.MONGO_SCOPE, ExecutionPolicy.BOUNDARY);
                }
                InstrumentMethod getReadPreference = InstrumentUtils.findMethod((InstrumentClass)target, (String)"withReadPreference", (String[])new String[]{"com.mongodb.ReadPreference"});
                getReadPreference.addScopedInterceptor("com.navercorp.pinpoint.plugin.mongo.interceptor.MongoReadPreferenceInterceptor", MongoPlugin.MONGO_SCOPE, ExecutionPolicy.BOUNDARY);
                InstrumentMethod getWriteConcern = InstrumentUtils.findMethod((InstrumentClass)target, (String)"withWriteConcern", (String[])new String[]{"com.mongodb.WriteConcern"});
                getWriteConcern.addScopedInterceptor("com.navercorp.pinpoint.plugin.mongo.interceptor.MongoWriteConcernInterceptor", MongoPlugin.MONGO_SCOPE, ExecutionPolicy.BOUNDARY);
                return target.toBytecode();
            }
        };
        this.transformTemplate.transform("com.mongodb.MongoCollectionImpl", transformCallback);
    }

    private void addSessionTransformer3_7_X(final MongoConfig config) {
        TransformCallback transformCallback = new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (!target.isInterceptable()) {
                    return null;
                }
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.chain((MethodFilter[])new MethodFilter[]{MethodFilters.modifier((int)1), MethodFilters.name((String[])MongoPlugin.this.getMethodlistR3_7_x())}))) {
                    method.addScopedInterceptor("com.navercorp.pinpoint.plugin.mongo.interceptor.MongoRSessionInterceptor", VarArgs.va((Object[])new Object[]{config.isCollectJson(), config.istraceBsonBindValue()}), MongoPlugin.MONGO_SCOPE, ExecutionPolicy.BOUNDARY);
                }
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.chain((MethodFilter[])new MethodFilter[]{MethodFilters.modifier((int)1), MethodFilters.name((String[])MongoPlugin.this.getMethodlistCUD3_7_x())}))) {
                    method.addScopedInterceptor("com.navercorp.pinpoint.plugin.mongo.interceptor.MongoCUDSessionInterceptor", VarArgs.va((Object[])new Object[]{config.isCollectJson(), config.istraceBsonBindValue()}), MongoPlugin.MONGO_SCOPE, ExecutionPolicy.BOUNDARY);
                }
                InstrumentMethod getReadPreference = InstrumentUtils.findMethod((InstrumentClass)target, (String)"withReadPreference", (String[])new String[]{"com.mongodb.ReadPreference"});
                getReadPreference.addScopedInterceptor("com.navercorp.pinpoint.plugin.mongo.interceptor.MongoReadPreferenceInterceptor", MongoPlugin.MONGO_SCOPE, ExecutionPolicy.BOUNDARY);
                InstrumentMethod getWriteConcern = InstrumentUtils.findMethod((InstrumentClass)target, (String)"withWriteConcern", (String[])new String[]{"com.mongodb.WriteConcern"});
                getWriteConcern.addScopedInterceptor("com.navercorp.pinpoint.plugin.mongo.interceptor.MongoWriteConcernInterceptor", MongoPlugin.MONGO_SCOPE, ExecutionPolicy.BOUNDARY);
                return target.toBytecode();
            }
        };
        this.transformTemplate.transform("com.mongodb.client.internal.MongoCollectionImpl", transformCallback);
    }

    private void addFilterTransformer() {
        TransformCallback transformCallback = new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (!target.isInterceptable()) {
                    return null;
                }
                List nestedClasses = target.getNestedClasses(ClassFilters.name((String[])MongoConstants.FILTERLIST.toArray(new String[0])));
                for (InstrumentClass nestedClass : nestedClasses) {
                    if (nestedClass.getName().equals("com.mongodb.client.model.Filters$.GeometryOperatorFilter")) {
                        instrumentor.transform(loader, nestedClass.getName(), new TransformCallback(){

                            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                                InstrumentClass nestedTarget = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                                if (!nestedTarget.isInterceptable()) {
                                    return null;
                                }
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.filters.OperatorNameGetter", "operatorName");
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.filters.FilterGetter", "fieldName");
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.filters.GeometryGetter", "geometry");
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.filters.MaxDistanceGetter", "maxDistance");
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.filters.MinDistanceGetter", "minDistance");
                                return nestedTarget.toBytecode();
                            }
                        });
                    }
                    if (nestedClass.getName().equals("com.mongodb.client.model.Filters$NotFilter")) {
                        instrumentor.transform(loader, nestedClass.getName(), new TransformCallback(){

                            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                                InstrumentClass nestedTarget = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                                if (!nestedTarget.isInterceptable()) {
                                    return null;
                                }
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.filters.FilterGetter", "filter");
                                return nestedTarget.toBytecode();
                            }
                        });
                    }
                    if (nestedClass.getName().equals("com.mongodb.client.model.Filters$SimpleEncodingFilter")) {
                        instrumentor.transform(loader, nestedClass.getName(), new TransformCallback(){

                            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                                InstrumentClass nestedTarget = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                                if (!nestedTarget.isInterceptable()) {
                                    return null;
                                }
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.FieldNameGetter", "fieldName");
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.ValueGetter", "value");
                                return nestedTarget.toBytecode();
                            }
                        });
                    }
                    if (nestedClass.getName().equals("com.mongodb.client.model.Filters$IterableOperatorFilter")) {
                        instrumentor.transform(loader, nestedClass.getName(), new TransformCallback(){

                            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                                InstrumentClass nestedTarget = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                                if (!nestedTarget.isInterceptable()) {
                                    return null;
                                }
                                if (nestedTarget.hasField("fieldName")) {
                                    nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.FieldNameGetter", "fieldName");
                                }
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.filters.OperatorNameGetter", "operatorName");
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.filters.IterableValuesGetter", "values");
                                return nestedTarget.toBytecode();
                            }
                        });
                    }
                    if (nestedClass.getName().equals("com.mongodb.client.model.Filters$OrFilter")) {
                        instrumentor.transform(loader, nestedClass.getName(), new TransformCallback(){

                            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                                InstrumentClass nestedTarget = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                                if (!nestedTarget.isInterceptable()) {
                                    return null;
                                }
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.filters.FiltersGetter", "filters");
                                return nestedTarget.toBytecode();
                            }
                        });
                    }
                    if (nestedClass.getName().equals("com.mongodb.client.model.Filters$AndFilter")) {
                        instrumentor.transform(loader, nestedClass.getName(), new TransformCallback(){

                            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                                InstrumentClass nestedTarget = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                                if (!nestedTarget.isInterceptable()) {
                                    return null;
                                }
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.filters.FiltersGetter", "filters");
                                return nestedTarget.toBytecode();
                            }
                        });
                    }
                    if (nestedClass.getName().equals("com.mongodb.client.model.Filters$OperatorFilter")) {
                        instrumentor.transform(loader, nestedClass.getName(), new TransformCallback(){

                            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                                InstrumentClass nestedTarget = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                                if (!nestedTarget.isInterceptable()) {
                                    return null;
                                }
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.filters.OperatorNameGetter", "operatorName");
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.FieldNameGetter", "fieldName");
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.ValueGetter", "value");
                                return nestedTarget.toBytecode();
                            }
                        });
                    }
                    if (nestedClass.getName().equals("com.mongodb.client.model.Filters$SimpleFilter")) {
                        instrumentor.transform(loader, nestedClass.getName(), new TransformCallback(){

                            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                                InstrumentClass nestedTarget = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.FieldNameGetter", "fieldName");
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.filters.BsonValueGetter", "value");
                                return nestedTarget.toBytecode();
                            }
                        });
                    }
                    if (nestedClass.getName().equals("com.mongodb.client.model.Filters$TextFilter")) {
                        instrumentor.transform(loader, nestedClass.getName(), new TransformCallback(){

                            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                                InstrumentClass nestedTarget = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                                if (!nestedTarget.isInterceptable()) {
                                    return null;
                                }
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.filters.SearchGetter", "search");
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.filters.TextSearchOptionsGetter", "textSearchOptions");
                                return nestedTarget.toBytecode();
                            }
                        });
                    }
                    if (!nestedClass.getName().equals("com.mongodb.client.model.Filters$OrNorFilter")) continue;
                    instrumentor.transform(loader, nestedClass.getName(), new TransformCallback(){

                        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                            InstrumentClass nestedTarget = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                            if (!nestedTarget.isInterceptable()) {
                                return null;
                            }
                            nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.filters.FiltersGetter", "filters");
                            nestedTarget.addField("com.navercorp.pinpoint.plugin.mongo.field.getter.filters.InternalOperatorNameAccessor");
                            InstrumentMethod nestedConstructor = nestedTarget.getConstructor(new String[]{"com.mongodb.client.model.Filters$OrNorFilter$Operator", "java.lang.Iterable"});
                            if (nestedConstructor != null) {
                                nestedConstructor.addInterceptor("com.navercorp.pinpoint.plugin.mongo.interceptor.MongoInternalOperatorNameInterceptor");
                            }
                            return nestedTarget.toBytecode();
                        }
                    });
                }
                return target.toBytecode();
            }
        };
        this.transformTemplate.transform("com.mongodb.client.model.Filters", transformCallback);
    }

    private void addUpdatesTransformer() {
        TransformCallback transformCallback = new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (!target.isInterceptable()) {
                    return null;
                }
                List nestedClasses = target.getNestedClasses(ClassFilters.name((String[])MongoConstants.UPDATESLIST.toArray(new String[0])));
                for (InstrumentClass nestedClass : nestedClasses) {
                    if (nestedClass.getName().equals("com.mongodb.client.model.Updates$SimpleUpdate")) {
                        instrumentor.transform(loader, nestedClass.getName(), new TransformCallback(){

                            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                                InstrumentClass nestedTarget = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                                if (!nestedTarget.isInterceptable()) {
                                    return null;
                                }
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.FieldNameGetter", "fieldName");
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.ValueGetter", "value");
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.OperatorGetter", "operator");
                                return nestedTarget.toBytecode();
                            }
                        });
                    }
                    if (nestedClass.getName().equals("com.mongodb.client.model.Updates$WithEachUpdate")) {
                        instrumentor.transform(loader, nestedClass.getName(), new TransformCallback(){

                            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                                InstrumentClass nestedTarget = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                                if (!nestedTarget.isInterceptable()) {
                                    return null;
                                }
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.FieldNameGetter", "fieldName");
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.updates.ListValuesGetter", "values");
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.OperatorGetter", "operator");
                                return nestedTarget.toBytecode();
                            }
                        });
                    }
                    if (nestedClass.getName().equals("com.mongodb.client.model.Updates$PushUpdate")) {
                        instrumentor.transform(loader, nestedClass.getName(), new TransformCallback(){

                            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                                InstrumentClass nestedTarget = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                                if (!nestedTarget.isInterceptable()) {
                                    return null;
                                }
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.updates.PushOptionsGetter", "options");
                                return nestedTarget.toBytecode();
                            }
                        });
                    }
                    if (nestedClass.getName().equals("com.mongodb.client.model.Updates$PullAllUpdate")) {
                        instrumentor.transform(loader, nestedClass.getName(), new TransformCallback(){

                            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                                InstrumentClass nestedTarget = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                                if (!nestedTarget.isInterceptable()) {
                                    return null;
                                }
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.FieldNameGetter", "fieldName");
                                nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.updates.ListValuesGetter", "values");
                                return nestedTarget.toBytecode();
                            }
                        });
                    }
                    if (!nestedClass.getName().equals("com.mongodb.client.model.Updates$CompositeUpdate")) continue;
                    instrumentor.transform(loader, nestedClass.getName(), new TransformCallback(){

                        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                            InstrumentClass nestedTarget = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                            if (!nestedTarget.isInterceptable()) {
                                return null;
                            }
                            nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.ExtendedBsonListGetter", "updates");
                            return nestedTarget.toBytecode();
                        }
                    });
                }
                return target.toBytecode();
            }
        };
        this.transformTemplate.transform("com.mongodb.client.model.Updates", transformCallback);
    }

    private void addSortsTransformer() {
        TransformCallback transformCallback = new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (!target.isInterceptable()) {
                    return null;
                }
                List nestedClasses = target.getNestedClasses(ClassFilters.name((String[])new String[]{"com.mongodb.client.model.Sorts$CompoundSort"}));
                for (InstrumentClass nestedClass : nestedClasses) {
                    if (!nestedClass.getName().equals("com.mongodb.client.model.Sorts$CompoundSort")) continue;
                    instrumentor.transform(loader, nestedClass.getName(), new TransformCallback(){

                        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                            InstrumentClass nestedTarget = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                            if (!nestedTarget.isInterceptable()) {
                                return null;
                            }
                            nestedTarget.addGetter("com.navercorp.pinpoint.plugin.mongo.field.getter.ExtendedBsonListGetter", "updates");
                            return nestedTarget.toBytecode();
                        }
                    });
                }
                return target.toBytecode();
            }
        };
        this.transformTemplate.transform("com.mongodb.client.model.Sorts", transformCallback);
    }

    private String[] getMethodlistR3_0_x() {
        String[] methodList = new String[]{"findOneAndUpdate", "findOneAndReplace", "findOneAndDelete", "find", "count", "distinct", "listIndexes"};
        return methodList;
    }

    private String[] getMethodlistCUD3_0_x() {
        String[] methodList = new String[]{"dropIndexes", "dropIndex", "createIndexes", "createIndex", "updateMany", "updateOne", "replaceOne", "deleteMany", "deleteOne", "insertMany", "insertOne", "bulkWrite"};
        return methodList;
    }

    private String[] getMethodlistR3_7_x() {
        String[] methodList = new String[]{"findOneAndUpdate", "findOneAndReplace", "findOneAndDelete", "find", "count", "distinct", "listIndexes", "countDocuments"};
        return methodList;
    }

    private String[] getMethodlistCUD3_7_x() {
        String[] methodlist = new String[]{"dropIndexes", "dropIndex", "createIndexes", "createIndex", "updateMany", "updateOne", "replaceOne", "deleteMany", "deleteOne", "insertMany", "insertOne", "bulkWrite"};
        return methodlist;
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

