/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.dubbo.interceptor;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcInvocation;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.plugin.dubbo.DubboConstants;

public class DubboConsumerInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final MethodDescriptor descriptor;
    private final TraceContext traceContext;

    public DubboConsumerInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        this.descriptor = descriptor;
        this.traceContext = traceContext;
    }

    public void before(Object target, Object[] args) {
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if (this.isMonitorService(target)) {
            return;
        }
        Trace trace = this.traceContext.currentRawTraceObject();
        if (trace == null) {
            return;
        }
        RpcInvocation invocation = (RpcInvocation)args[0];
        if (trace.canSampled()) {
            SpanEventRecorder recorder = trace.traceBlockBegin();
            recorder.recordServiceType(DubboConstants.DUBBO_CONSUMER_SERVICE_TYPE);
            TraceId nextId = trace.getTraceId().getNextTraceId();
            recorder.recordNextSpanId(nextId.getSpanId());
            this.setAttachment(invocation, "_DUBBO_TRASACTION_ID", nextId.getTransactionId());
            this.setAttachment(invocation, "_DUBBO_SPAN_ID", Long.toString(nextId.getSpanId()));
            this.setAttachment(invocation, "_DUBBO_PARENT_SPAN_ID", Long.toString(nextId.getParentSpanId()));
            this.setAttachment(invocation, "_DUBBO_PARENT_APPLICATION_TYPE", Short.toString(this.traceContext.getServerTypeCode()));
            this.setAttachment(invocation, "_DUBBO_PARENT_APPLICATION_NAME", this.traceContext.getApplicationName());
            this.setAttachment(invocation, "_DUBBO_FLAGS", Short.toString(nextId.getFlags()));
            this.setAttachment(invocation, "_DUBBO_HOST", this.getHostAddress(invocation));
        } else {
            this.setAttachment(invocation, "_DUBBO_DO_NOT_TRACE", "1");
        }
    }

    private String getHostAddress(RpcInvocation invocation) {
        URL url = invocation.getInvoker().getUrl();
        return HostAndPort.toHostAndPortString((String)url.getHost(), (int)url.getPort());
    }

    private void setAttachment(RpcInvocation invocation, String name, String value) {
        invocation.setAttachment(name, value);
        if (this.isDebug) {
            this.logger.debug("Set attachment {}={}", (Object)name, (Object)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args);
        }
        if (this.isMonitorService(target)) {
            return;
        }
        Trace trace = this.traceContext.currentTraceObject();
        if (trace == null) {
            return;
        }
        try {
            RpcInvocation invocation = (RpcInvocation)args[0];
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.descriptor);
            if (throwable == null) {
                String endPoint = RpcContext.getContext().getRemoteAddressString();
                recorder.recordEndPoint(endPoint);
                recorder.recordDestinationId(endPoint);
                recorder.recordAttribute(DubboConstants.DUBBO_ARGS_ANNOTATION_KEY, (Object)invocation.getArguments());
                recorder.recordAttribute(DubboConstants.DUBBO_RESULT_ANNOTATION_KEY, result);
            } else {
                recorder.recordException(throwable);
            }
        }
        finally {
            trace.traceBlockEnd();
        }
    }

    private boolean isMonitorService(Object target) {
        if (target instanceof Invoker) {
            Invoker invoker = (Invoker)target;
            return "com.alibaba.dubbo.monitor.MonitorService".equals(invoker.getInterface().getName());
        }
        return false;
    }
}

