/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.openwhisk.interceptor;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessorUtils;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.openwhisk.OpenwhiskConstants;
import com.navercorp.pinpoint.plugin.openwhisk.setter.TraceContextSetter;
import scala.Option;
import scala.collection.GenTraversableOnce;
import scala.collection.immutable.Map;
import whisk.core.connector.ActivationMessage;

public class KafkaProducerSendInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    protected final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor descriptor;

    public KafkaProducerSendInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        this.traceContext = traceContext;
        this.descriptor = methodDescriptor;
    }

    public void before(Object target, Object[] args) {
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if (!(args[1] instanceof ActivationMessage)) {
            this.logger.debug("It is not ActivationMessage");
            return;
        }
        ActivationMessage activationMessage = (ActivationMessage)args[1];
        AsyncContext asyncContext = AsyncContextAccessorUtils.getAsyncContext((Object)activationMessage.transid());
        if (asyncContext == null) {
            this.logger.debug("Not found asynchronous invocation metadata");
            return;
        }
        Trace trace = asyncContext.continueAsyncTraceObject();
        if (trace == null) {
            return;
        }
        SpanEventRecorder recorder = trace.traceBlockBegin();
        TraceId nextId = trace.getTraceId().getNextTraceId();
        String applicationName = this.traceContext.getApplicationName();
        String serverTypeCode = Short.toString(this.traceContext.getServerTypeCode());
        String entityPath = String.valueOf(activationMessage.action());
        String endPoint = args[0].toString();
        recorder.recordServiceType(OpenwhiskConstants.OPENWHISK_CLIENT);
        recorder.recordApi(this.descriptor);
        recorder.recordNextSpanId(nextId.getSpanId());
        recorder.recordEndPoint(endPoint);
        recorder.recordDestinationId(endPoint);
        Map.Map4 map = new Map.Map4((Object)"transactionId", (Object)nextId.getTransactionId(), (Object)"spanId", (Object)String.valueOf(nextId.getSpanId()), (Object)"parentSpanId", (Object)String.valueOf(nextId.getParentSpanId()), (Object)"flag", (Object)String.valueOf(nextId.getFlags()));
        Map.Map4 traceMetadata = new Map.Map4((Object)"applicationName", (Object)applicationName, (Object)"serverTypeCode", (Object)serverTypeCode, (Object)"entityPath", (Object)entityPath, (Object)"endPoint", (Object)endPoint);
        map = map.$plus$plus((GenTraversableOnce)traceMetadata.toSeq());
        ((TraceContextSetter)activationMessage)._$PINPOINT$_setTraceContext(Option.apply((Object)map));
        trace.traceBlockEnd();
        this.deleteTrace(trace);
        asyncContext.close();
    }

    private void deleteTrace(Trace trace) {
        this.traceContext.removeTraceObject();
        trace.close();
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
    }
}

