/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.openwhisk;

import com.navercorp.pinpoint.bootstrap.plugin.ApplicationTypeDetector;
import com.navercorp.pinpoint.bootstrap.resolver.ConditionProvider;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.plugin.openwhisk.OpenwhiskConstants;

public class OpenwhiskDetector
implements ApplicationTypeDetector {
    private static final String CONTROLLER_REQUIRED_CLASS = "whisk.core.controller.Controller";
    private static final String INVOKER_REQUIRED_CLASS = "whisk.core.invoker.Invoker";
    private ServiceType applicationType = OpenwhiskConstants.OPENWHISK_INTERNAL;

    public ServiceType getApplicationType() {
        return this.applicationType;
    }

    public boolean detect(ConditionProvider provider) {
        return this.setOpenwhiskApplicationType(provider);
    }

    private boolean setOpenwhiskApplicationType(ConditionProvider provider) {
        if (provider.checkForClass(CONTROLLER_REQUIRED_CLASS)) {
            this.applicationType = OpenwhiskConstants.OPENWHISK_CONTROLLER;
            return true;
        }
        if (provider.checkForClass(INVOKER_REQUIRED_CLASS)) {
            this.applicationType = OpenwhiskConstants.OPENWHISK_INVOKER;
            return true;
        }
        return false;
    }
}

