/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jackson;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.jackson.JacksonConfig;
import com.navercorp.pinpoint.plugin.jackson.JacksonConstants;
import java.security.ProtectionDomain;

public class JacksonPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private static final String JACKSON_SCOPE = "JACKSON_OBJECTMAPPER_SCOPE";
    private static final String BASIC_METHOD_INTERCEPTOR = "com.navercorp.pinpoint.bootstrap.interceptor.BasicMethodInterceptor";
    private static final String READ_VALUE_INTERCEPTOR = "com.navercorp.pinpoint.plugin.jackson.interceptor.ReadValueInterceptor";
    private static final String WRITE_VALUE_AS_BYTES_INTERCEPTOR = "com.navercorp.pinpoint.plugin.jackson.interceptor.WriteValueAsBytesInterceptor";
    private static final String WRITE_VALUE_AS_STRING_INTERCEPTOR = "com.navercorp.pinpoint.plugin.jackson.interceptor.WriteValueAsStringInterceptor";
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        JacksonConfig config = new JacksonConfig(context.getConfig());
        this.logger.debug("[Jackson] Initialized config={}", (Object)config);
        if (config.isProfile()) {
            this.addObjectMapperEditor("com.fasterxml.jackson.databind.ObjectMapper");
            this.addObjectReaderEditor("com.fasterxml.jackson.databind.ObjectReader");
            this.addObjectWriterEditor("com.fasterxml.jackson.databind.ObjectWriter");
            this.addObjectMapper_1_X_Editor("org.codehaus.jackson.map.ObjectMapper");
            this.addObjectReaderEditor("org.codehaus.jackson.map.ObjectReader");
            this.addObjectWriterEditor("org.codehaus.jackson.map.ObjectWriter");
        }
    }

    private void addObjectMapperEditor(String clazzName) {
        this.transformTemplate.transform(clazzName, new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod constructor1 = target.getConstructor(new String[0]);
                JacksonPlugin.this.addInterceptor(constructor1, JacksonPlugin.BASIC_METHOD_INTERCEPTOR, VarArgs.va((Object[])new Object[]{JacksonConstants.SERVICE_TYPE}));
                InstrumentMethod constructor2 = target.getConstructor(new String[]{"com.fasterxml.jackson.core.JsonFactory"});
                JacksonPlugin.this.addInterceptor(constructor2, JacksonPlugin.BASIC_METHOD_INTERCEPTOR, VarArgs.va((Object[])new Object[]{JacksonConstants.SERVICE_TYPE}));
                InstrumentMethod constructor3 = target.getConstructor(new String[]{"com.fasterxml.jackson.core.JsonFactory", "com.fasterxml.jackson.databind.ser.DefaultSerializerProvider", "com.fasterxml.jackson.databind.deser.DefaultDeserializationContext"});
                JacksonPlugin.this.addInterceptor(constructor3, JacksonPlugin.BASIC_METHOD_INTERCEPTOR, VarArgs.va((Object[])new Object[]{JacksonConstants.SERVICE_TYPE}));
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"writeValue"}))) {
                    JacksonPlugin.this.addInterceptor(method, JacksonPlugin.BASIC_METHOD_INTERCEPTOR, VarArgs.va((Object[])new Object[]{JacksonConstants.SERVICE_TYPE}));
                }
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"writeValueAsString"}))) {
                    JacksonPlugin.this.addInterceptor(method, JacksonPlugin.WRITE_VALUE_AS_STRING_INTERCEPTOR);
                }
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"writeValueAsBytes"}))) {
                    JacksonPlugin.this.addInterceptor(method, JacksonPlugin.WRITE_VALUE_AS_BYTES_INTERCEPTOR);
                }
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"readValue"}))) {
                    JacksonPlugin.this.addInterceptor(method, JacksonPlugin.READ_VALUE_INTERCEPTOR);
                }
                return target.toBytecode();
            }
        });
    }

    private void addObjectMapper_1_X_Editor(String clazzName) {
        this.transformTemplate.transform(clazzName, new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod constructor1 = target.getConstructor(new String[0]);
                JacksonPlugin.this.addInterceptor(constructor1, JacksonPlugin.BASIC_METHOD_INTERCEPTOR, VarArgs.va((Object[])new Object[]{JacksonConstants.SERVICE_TYPE}));
                InstrumentMethod constructor2 = target.getConstructor(new String[]{"org.codehaus.jackson.JsonFactory"});
                JacksonPlugin.this.addInterceptor(constructor2, JacksonPlugin.BASIC_METHOD_INTERCEPTOR, VarArgs.va((Object[])new Object[]{JacksonConstants.SERVICE_TYPE}));
                InstrumentMethod constructor3 = target.getConstructor(new String[]{"org.codehaus.jackson.JsonFactory", "org.codehaus.jackson.map.SerializerProvider", "org.codehaus.jackson.map.DeserializerProvider"});
                JacksonPlugin.this.addInterceptor(constructor3, JacksonPlugin.BASIC_METHOD_INTERCEPTOR, VarArgs.va((Object[])new Object[]{JacksonConstants.SERVICE_TYPE}));
                InstrumentMethod constructor4 = target.getConstructor(new String[]{"org.codehaus.jackson.map.SerializerFactory"});
                JacksonPlugin.this.addInterceptor(constructor4, JacksonPlugin.BASIC_METHOD_INTERCEPTOR, VarArgs.va((Object[])new Object[]{JacksonConstants.SERVICE_TYPE}));
                InstrumentMethod constructor5 = target.getConstructor(new String[]{"org.codehaus.jackson.JsonFactory", "org.codehaus.jackson.map.SerializerProvider", "org.codehaus.jackson.map.DeserializerProvider", "org.codehaus.jackson.map.SerializationConfig", "org.codehaus.jackson.map.DeserializationConfig"});
                JacksonPlugin.this.addInterceptor(constructor5, JacksonPlugin.BASIC_METHOD_INTERCEPTOR, VarArgs.va((Object[])new Object[]{JacksonConstants.SERVICE_TYPE}));
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"writeValue"}))) {
                    JacksonPlugin.this.addInterceptor(method, JacksonPlugin.BASIC_METHOD_INTERCEPTOR, VarArgs.va((Object[])new Object[]{JacksonConstants.SERVICE_TYPE}));
                }
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"writeValueAsString"}))) {
                    JacksonPlugin.this.addInterceptor(method, JacksonPlugin.WRITE_VALUE_AS_STRING_INTERCEPTOR);
                }
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"writeValueAsBytes"}))) {
                    JacksonPlugin.this.addInterceptor(method, JacksonPlugin.WRITE_VALUE_AS_BYTES_INTERCEPTOR);
                }
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"readValue"}))) {
                    JacksonPlugin.this.addInterceptor(method, JacksonPlugin.READ_VALUE_INTERCEPTOR);
                }
                return target.toBytecode();
            }
        });
    }

    private void addObjectReaderEditor(String clazzName) {
        this.transformTemplate.transform(clazzName, new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"readValue", "readValues"}))) {
                    JacksonPlugin.this.addInterceptor(method, JacksonPlugin.READ_VALUE_INTERCEPTOR);
                }
                return target.toBytecode();
            }
        });
    }

    private void addObjectWriterEditor(String clazzName) {
        this.transformTemplate.transform(clazzName, new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"writeValue"}))) {
                    JacksonPlugin.this.addInterceptor(method, JacksonPlugin.BASIC_METHOD_INTERCEPTOR, VarArgs.va((Object[])new Object[]{JacksonConstants.SERVICE_TYPE}));
                }
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"writeValueAsString"}))) {
                    JacksonPlugin.this.addInterceptor(method, JacksonPlugin.WRITE_VALUE_AS_STRING_INTERCEPTOR);
                }
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"writeValueAsBytes"}))) {
                    JacksonPlugin.this.addInterceptor(method, JacksonPlugin.WRITE_VALUE_AS_BYTES_INTERCEPTOR);
                }
                return target.toBytecode();
            }
        });
    }

    private boolean addInterceptor(InstrumentMethod method, String interceptorClassName) {
        block3: {
            if (method != null) {
                try {
                    method.addScopedInterceptor(interceptorClassName, JACKSON_SCOPE);
                    return true;
                }
                catch (InstrumentException e) {
                    if (!this.logger.isWarnEnabled()) break block3;
                    this.logger.warn("Unsupported method " + method, (Throwable)e);
                }
            }
        }
        return false;
    }

    private boolean addInterceptor(InstrumentMethod method, String interceptorClassName, Object[] constructorArgs) {
        block3: {
            if (method != null) {
                try {
                    method.addScopedInterceptor(interceptorClassName, constructorArgs, JACKSON_SCOPE);
                    return true;
                }
                catch (InstrumentException e) {
                    if (!this.logger.isWarnEnabled()) break block3;
                    this.logger.warn("Unsupported method " + method, (Throwable)e);
                }
            }
        }
        return false;
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

