/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.thrift.interceptor.tprotocol.server;

import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.thrift.ThriftClientCallContext;
import com.navercorp.pinpoint.plugin.thrift.ThriftHeader;
import com.navercorp.pinpoint.plugin.thrift.field.accessor.ServerMarkerFlagFieldAccessor;
import org.apache.thrift.protocol.TField;

public class TProtocolReadFieldBeginInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final InterceptorScope scope;

    public TProtocolReadFieldBeginInterceptor(InterceptorScope scope) {
        this.scope = scope;
    }

    public void before(Object target, Object[] args) {
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        InterceptorScopeInvocation currentTransaction;
        Object attachment;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if (!this.validate(target)) {
            return;
        }
        boolean shouldTrace = ((ServerMarkerFlagFieldAccessor)target)._$PINPOINT$_getServerMarkerFlag();
        if (shouldTrace && (attachment = (currentTransaction = this.scope.getCurrentInvocation()).getAttachment()) instanceof ThriftClientCallContext) {
            ThriftClientCallContext clientCallContext = (ThriftClientCallContext)attachment;
            if (result instanceof TField) {
                this.handleClientRequest((TField)result, clientCallContext);
            }
        }
    }

    private boolean validate(Object target) {
        if (!(target instanceof ServerMarkerFlagFieldAccessor)) {
            if (this.isDebug) {
                this.logger.debug("Invalid target object. Need field accessor({}).", (Object)ServerMarkerFlagFieldAccessor.class.getName());
            }
            return false;
        }
        return true;
    }

    private void handleClientRequest(TField field, ThriftClientCallContext clientCallContext) {
        ThriftHeader traceHeaderKey = ThriftHeader.findThriftHeaderKeyById(field.id);
        if (traceHeaderKey == null || field.type != traceHeaderKey.getType()) {
            clientCallContext.setTraceHeaderToBeRead(ThriftClientCallContext.NONE);
        } else {
            clientCallContext.setTraceHeaderToBeRead(traceHeaderKey);
        }
    }
}

