/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.thrift.interceptor.server;

import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.thrift.ThriftClientCallContext;
import com.navercorp.pinpoint.plugin.thrift.field.accessor.ServerMarkerFlagFieldAccessor;
import com.navercorp.pinpoint.plugin.thrift.field.getter.TProtocolFieldGetter;
import org.apache.thrift.ProcessFunction;
import org.apache.thrift.protocol.TProtocol;

public class ProcessFunctionProcessInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final InterceptorScope scope;

    public ProcessFunctionProcessInterceptor(InterceptorScope scope) {
        this.scope = scope;
    }

    public void before(Object target, Object[] args) {
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if (args.length != 4) {
            return;
        }
        String methodName = "unknown";
        if (target instanceof ProcessFunction) {
            ProcessFunction processFunction = (ProcessFunction)target;
            methodName = processFunction.getMethodName();
        }
        ThriftClientCallContext clientCallContext = new ThriftClientCallContext(methodName);
        InterceptorScopeInvocation currentTransaction = this.scope.getCurrentInvocation();
        currentTransaction.setAttachment((Object)clientCallContext);
        Object iprot = args[1];
        Object rootInputProtocol = this.getRootInputProtocol(iprot);
        if (this.validateInputProtocol(rootInputProtocol)) {
            ((ServerMarkerFlagFieldAccessor)rootInputProtocol)._$PINPOINT$_setServerMarkerFlag(true);
        }
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Object iprot;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if (args.length != 4 && this.validateInputProtocol(iprot = args[1])) {
            ((ServerMarkerFlagFieldAccessor)iprot)._$PINPOINT$_setServerMarkerFlag(false);
        }
    }

    private Object getRootInputProtocol(Object iprot) {
        if (iprot instanceof TProtocolFieldGetter) {
            return this.getRootInputProtocol(((TProtocolFieldGetter)iprot)._$PINPOINT$_getTProtocol());
        }
        return iprot;
    }

    private boolean validateInputProtocol(Object iprot) {
        if (iprot instanceof TProtocol) {
            if (iprot instanceof ServerMarkerFlagFieldAccessor) {
                return true;
            }
            if (this.isDebug) {
                this.logger.debug("Invalid target object. Need field accessor({}).", (Object)ServerMarkerFlagFieldAccessor.class.getName());
            }
            return false;
        }
        return false;
    }
}

