/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.test.util;

import com.navercorp.pinpoint.common.util.IOUtils;
import com.navercorp.pinpoint.profiler.util.JavaAssistUtils;
import java.io.IOException;
import java.io.InputStream;

public final class BytecodeUtils {
    private BytecodeUtils() {
    }

    public static byte[] getClassFile(ClassLoader classLoader, String className) {
        String classInternalName;
        if (className == null) {
            throw new NullPointerException("className must not be null");
        }
        InputStream is = (classLoader = BytecodeUtils.getClassLoader(classLoader)).getResourceAsStream(classInternalName = JavaAssistUtils.javaClassNameToJvmResourceName((String)className));
        if (is == null) {
            throw new RuntimeException("No such class file: " + className);
        }
        try {
            return IOUtils.toByteArray((InputStream)is);
        }
        catch (IOException e) {
            throw new RuntimeException("class read fail file: " + className, e);
        }
    }

    private static ClassLoader getClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }
}

