/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.hbase.interceptor;

import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.plugin.hbase.HbasePluginConstants;

public class HbaseClientMainInterceptor
implements AroundInterceptor {
    private final MethodDescriptor descriptor;
    private final TraceContext traceContext;
    private final InterceptorScope scope;

    public HbaseClientMainInterceptor(TraceContext traceContext, MethodDescriptor descriptor, InterceptorScope scope) {
        this.traceContext = traceContext;
        this.descriptor = descriptor;
        this.scope = scope;
    }

    public void before(Object target, Object[] args) {
        Trace trace = this.traceContext.currentTraceObject();
        if (trace == null) {
            return;
        }
        SpanEventRecorder recorder = trace.traceBlockBegin();
        recorder.recordServiceType(HbasePluginConstants.HBASE_ASYNC_CLIENT);
        recorder.recordApi(this.descriptor, args);
        AsyncContext asyncContext = recorder.recordNextAsyncContext();
        this.scope.getCurrentInvocation().setAttachment((Object)asyncContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace = this.traceContext.currentTraceObject();
        if (trace == null) {
            return;
        }
        try {
            if (throwable != null) {
                SpanEventRecorder recorder = trace.currentSpanEventRecorder();
                recorder.recordException(throwable);
            }
        }
        finally {
            trace.traceBlockEnd();
        }
    }
}

