/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap;

import com.navercorp.pinpoint.bootstrap.Agent;
import com.navercorp.pinpoint.bootstrap.AgentBootLoader;
import com.navercorp.pinpoint.bootstrap.AgentOption;
import com.navercorp.pinpoint.bootstrap.BootLogger;
import com.navercorp.pinpoint.bootstrap.ContainerResolver;
import com.navercorp.pinpoint.bootstrap.DefaultAgentOption;
import com.navercorp.pinpoint.bootstrap.IdValidator;
import com.navercorp.pinpoint.bootstrap.ModuleBootLoader;
import com.navercorp.pinpoint.bootstrap.agentdir.AgentDirectory;
import com.navercorp.pinpoint.bootstrap.classloader.PinpointClassLoaderFactory;
import com.navercorp.pinpoint.bootstrap.classloader.ProfilerLibs;
import com.navercorp.pinpoint.bootstrap.config.DefaultProfilerConfig;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.common.util.PinpointThreadFactory;
import com.navercorp.pinpoint.common.util.SimpleProperty;
import com.navercorp.pinpoint.common.util.SystemProperty;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class PinpointStarter {
    private final BootLogger logger = BootLogger.getLogger(PinpointStarter.class.getName());
    public static final String AGENT_TYPE = "AGENT_TYPE";
    public static final String DEFAULT_AGENT = "DEFAULT_AGENT";
    public static final String BOOT_CLASS = "com.navercorp.pinpoint.profiler.DefaultAgent";
    public static final String PLUGIN_TEST_AGENT = "PLUGIN_TEST";
    public static final String PLUGIN_TEST_BOOT_CLASS = "com.navercorp.pinpoint.test.PluginTestAgent";
    private SimpleProperty systemProperty = SystemProperty.INSTANCE;
    private final Map<String, String> agentArgs;
    private final AgentDirectory agentDirectory;
    private final Instrumentation instrumentation;
    private final ClassLoader parentClassLoader;
    private final ModuleBootLoader moduleBootLoader;

    public PinpointStarter(ClassLoader parentClassLoader, Map<String, String> agentArgs, AgentDirectory agentDirectory, Instrumentation instrumentation, ModuleBootLoader moduleBootLoader) {
        if (agentArgs == null) {
            throw new NullPointerException("agentArgs must not be null");
        }
        if (agentDirectory == null) {
            throw new NullPointerException("agentDirectory must not be null");
        }
        if (instrumentation == null) {
            throw new NullPointerException("instrumentation must not be null");
        }
        this.agentArgs = agentArgs;
        this.parentClassLoader = parentClassLoader;
        this.agentDirectory = agentDirectory;
        this.instrumentation = instrumentation;
        this.moduleBootLoader = moduleBootLoader;
    }

    boolean start() {
        IdValidator idValidator = new IdValidator();
        String agentId = idValidator.getAgentId();
        if (agentId == null) {
            return false;
        }
        String applicationName = idValidator.getApplicationName();
        if (applicationName == null) {
            return false;
        }
        ContainerResolver containerResolver = new ContainerResolver();
        boolean isContainer = containerResolver.isContainer();
        List<String> pluginJars = this.agentDirectory.getPlugins();
        String configPath = this.getConfigPath(this.agentDirectory);
        if (configPath == null) {
            return false;
        }
        this.saveLogFilePath(this.agentDirectory);
        this.savePinpointVersion();
        try {
            ProfilerConfig profilerConfig = DefaultProfilerConfig.load((String)configPath);
            URL[] urls = this.resolveLib(this.agentDirectory);
            ClassLoader agentClassLoader = this.createClassLoader("pinpoint.agent", urls, this.parentClassLoader);
            if (this.moduleBootLoader != null) {
                this.logger.info("defineAgentModule");
                this.moduleBootLoader.defineAgentModule(agentClassLoader, urls);
            }
            String bootClass = this.getBootClass();
            AgentBootLoader agentBootLoader = new AgentBootLoader(bootClass, urls, agentClassLoader);
            this.logger.info("pinpoint agent [" + bootClass + "] starting...");
            AgentOption option = this.createAgentOption(agentId, applicationName, isContainer, profilerConfig, this.instrumentation, pluginJars, this.agentDirectory);
            Agent pinpointAgent = agentBootLoader.boot(option);
            pinpointAgent.start();
            this.registerShutdownHook(pinpointAgent);
            this.logger.info("pinpoint agent started normally.");
        }
        catch (Exception e) {
            this.logger.warn("pinpoint start failed.", e);
            return false;
        }
        return true;
    }

    private ClassLoader createClassLoader(final String name, final URL[] urls, final ClassLoader parentClassLoader) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return PinpointClassLoaderFactory.createClassLoader((String)name, (URL[])urls, (ClassLoader)parentClassLoader, (List)ProfilerLibs.PINPOINT_PROFILER_CLASS);
                }
            });
        }
        return PinpointClassLoaderFactory.createClassLoader((String)name, (URL[])urls, (ClassLoader)parentClassLoader, (List)ProfilerLibs.PINPOINT_PROFILER_CLASS);
    }

    private String getBootClass() {
        String agentType = this.getAgentType().toUpperCase();
        if (PLUGIN_TEST_AGENT.equals(agentType)) {
            return PLUGIN_TEST_BOOT_CLASS;
        }
        return BOOT_CLASS;
    }

    private String getAgentType() {
        String agentType = this.agentArgs.get(AGENT_TYPE);
        if (agentType == null) {
            return DEFAULT_AGENT;
        }
        return agentType;
    }

    private AgentOption createAgentOption(String agentId, String applicationName, boolean isContainer, ProfilerConfig profilerConfig, Instrumentation instrumentation, List<String> pluginJars, AgentDirectory agentDirectory) {
        List<String> bootstrapJarPaths = agentDirectory.getBootDir().toList();
        return new DefaultAgentOption(instrumentation, agentId, applicationName, isContainer, profilerConfig, pluginJars, bootstrapJarPaths);
    }

    void setSystemProperty(SimpleProperty systemProperty) {
        this.systemProperty = systemProperty;
    }

    private void registerShutdownHook(final Agent pinpointAgent) {
        Runnable stop = new Runnable(){

            @Override
            public void run() {
                pinpointAgent.stop();
            }
        };
        PinpointThreadFactory pinpointThreadFactory = new PinpointThreadFactory("Pinpoint-shutdown-hook", false);
        Thread thread = pinpointThreadFactory.newThread(stop);
        Runtime.getRuntime().addShutdownHook(thread);
    }

    private void saveLogFilePath(AgentDirectory agentDirectory) {
        String agentLogFilePath = agentDirectory.getAgentLogFilePath();
        this.logger.info("logPath:" + agentLogFilePath);
        this.systemProperty.setProperty("pinpoint.log", agentLogFilePath);
    }

    private void savePinpointVersion() {
        this.logger.info("pinpoint version:1.8.5");
        this.systemProperty.setProperty("pinpoint.version", "1.8.5");
    }

    private String getConfigPath(AgentDirectory agentDirectory) {
        String configName = "pinpoint.config";
        String pinpointConfigFormSystemProperty = this.systemProperty.getProperty("pinpoint.config");
        if (pinpointConfigFormSystemProperty != null) {
            this.logger.info("pinpoint.config systemProperty found. " + pinpointConfigFormSystemProperty);
            return pinpointConfigFormSystemProperty;
        }
        String classPathAgentConfigPath = agentDirectory.getAgentConfigPath();
        if (classPathAgentConfigPath != null) {
            this.logger.info("classpath pinpoint.config found. " + classPathAgentConfigPath);
            return classPathAgentConfigPath;
        }
        this.logger.info("pinpoint.config file not found.");
        return null;
    }

    private URL[] resolveLib(AgentDirectory classPathResolver) {
        String agentJarFullPath = classPathResolver.getAgentJarFullPath();
        String agentLibPath = classPathResolver.getAgentLibPath();
        List<URL> urlList = this.resolveLib(classPathResolver.getLibs());
        String agentConfigPath = classPathResolver.getAgentConfigPath();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("agent JarPath:" + agentJarFullPath);
            this.logger.info("agent LibDir:" + agentLibPath);
            for (URL url : urlList) {
                this.logger.info("agent Lib:" + url);
            }
            this.logger.info("agent config:" + agentConfigPath);
        }
        return urlList.toArray(new URL[0]);
    }

    private List<URL> resolveLib(List<URL> urlList) {
        if (DEFAULT_AGENT.equalsIgnoreCase(this.getAgentType())) {
            ArrayList<URL> releaseLib = new ArrayList<URL>(urlList.size());
            for (URL url : urlList) {
                if (url.toExternalForm().contains("pinpoint-profiler-test")) continue;
                releaseLib.add(url);
            }
            return releaseLib;
        }
        this.logger.info("load PLUGIN_TEST lib");
        return urlList;
    }
}

