/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.okhttp;

import com.navercorp.pinpoint.bootstrap.config.DumpType;
import com.navercorp.pinpoint.bootstrap.config.HttpDumpConfig;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;

public class OkHttpPluginConfig {
    private final boolean enable;
    private final boolean param;
    private final boolean statusCode;
    private final boolean async;
    private HttpDumpConfig httpDumpConfig;

    public OkHttpPluginConfig(ProfilerConfig src) {
        this.enable = src.readBoolean("profiler.okhttp.enable", true);
        this.param = src.readBoolean("profiler.okhttp.param", false);
        boolean cookie = src.readBoolean("profiler.okhttp.cookie", false);
        DumpType cookieDumpType = src.readDumpType("profiler.okhttp.cookie.dumptype", DumpType.EXCEPTION);
        int cookieSamplingRate = src.readInt("profiler.okhttp.cookie.sampling.rate", 1);
        int cookieDumpSize = src.readInt("profiler.okhttp.cookie.dumpsize", 1024);
        this.httpDumpConfig = HttpDumpConfig.get((boolean)cookie, (DumpType)cookieDumpType, (int)cookieSamplingRate, (int)cookieDumpSize, (boolean)false, (DumpType)cookieDumpType, (int)1, (int)1024);
        this.statusCode = src.readBoolean("profiler.okhttp.entity.statuscode", true);
        this.async = src.readBoolean("profiler.okhttp.async", true);
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean isParam() {
        return this.param;
    }

    public boolean isAsync() {
        return this.async;
    }

    public HttpDumpConfig getHttpDumpConfig() {
        return this.httpDumpConfig;
    }

    public boolean isStatusCode() {
        return this.statusCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OkHttpPluginConfig{");
        sb.append("enable=").append(this.enable);
        sb.append(", param=").append(this.param);
        sb.append(", statusCode=").append(this.statusCode);
        sb.append(", async=").append(this.async);
        sb.append(", httpDumpConfig=").append(this.httpDumpConfig);
        sb.append('}');
        return sb.toString();
    }
}

