/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.spring.beans;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilter;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.util.VarArgs;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class BeanMethodTransformer
implements TransformCallback {
    private static final int REQUIRED_ACCESS_FLAG = 1;
    private static final int REJECTED_ACCESS_FLAG = 1288;
    private static final MethodFilter METHOD_FILTER = MethodFilters.modifier((int)1, (int)1288);
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final Object lock = new Object();
    private final AtomicInteger interceptorId = new AtomicInteger(-1);
    private final boolean markError;

    public BeanMethodTransformer(boolean markError) {
        this.markError = markError;
    }

    public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
        try {
            InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
            if (!target.isInterceptable()) {
                return null;
            }
            List methodList = target.getDeclaredMethods(METHOD_FILTER);
            for (InstrumentMethod method : methodList) {
                this.addInterceptor(method);
            }
            return target.toBytecode();
        }
        catch (Exception e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Failed to spring beans modify. Cause:{}", (Object)e.getMessage(), (Object)e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInterceptor(InstrumentMethod targetMethod) throws InstrumentException {
        int id = this.interceptorId.get();
        if (id != -1) {
            targetMethod.addInterceptor(id);
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            id = this.interceptorId.get();
            if (id != -1) {
                targetMethod.addInterceptor(id);
                return;
            }
            id = targetMethod.addInterceptor("com.navercorp.pinpoint.plugin.spring.beans.interceptor.BeanMethodInterceptor", VarArgs.va((Object[])new Object[]{this.markError}));
            this.interceptorId.set(id);
        }
    }
}

