/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jetty.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.jetty.JettyAsyncListener;
import com.navercorp.pinpoint.plugin.jetty.JettyConstants;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;

public class RequestStartAsyncInterceptor
implements AroundInterceptor {
    private PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private boolean isDebug = this.logger.isDebugEnabled();
    private TraceContext traceContext;
    private MethodDescriptor descriptor;

    public RequestStartAsyncInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        this.traceContext = traceContext;
        this.descriptor = descriptor;
    }

    public void before(Object target, Object[] args) {
        Trace trace;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        trace.traceBlockBegin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            if (this.validate(target, result, throwable)) {
                AsyncContext asyncContext = (AsyncContext)result;
                JettyAsyncListener asyncListener = new JettyAsyncListener(this.traceContext, recorder.recordNextAsyncContext(true));
                asyncContext.addListener((AsyncListener)asyncListener);
                if (this.isDebug) {
                    this.logger.debug("Add async listener {}", (Object)asyncListener);
                }
            }
            recorder.recordServiceType(JettyConstants.JETTY_METHOD);
            recorder.recordApi(this.descriptor);
            recorder.recordException(throwable);
        }
        catch (Throwable t) {
            this.logger.warn("Failed to AFTER process. {}", (Object)t.getMessage(), (Object)t);
        }
        finally {
            trace.traceBlockEnd();
        }
    }

    private boolean validate(Object target, Object result, Throwable throwable) {
        if (throwable != null || result == null) {
            return false;
        }
        if (!(target instanceof HttpServletRequest)) {
            this.logger.debug("Invalid target object. {}", target);
            return false;
        }
        if (!(result instanceof AsyncContext)) {
            this.logger.debug("Invalid result object. {}.", result);
            return false;
        }
        return true;
    }
}

